package com.rocoinfo.rocomall.service.impl;

import java.util.List;

import javax.servlet.ServletContext;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cfg.Config;
import com.rocoinfo.rocomall.repository.cfg.ConfigDao;
import com.rocoinfo.rocomall.service.cfg.IConfigService;

@Service
public class ConfigService extends CrudService<ConfigDao, Config> implements IConfigService {

	public Config getByKey(final String key) {
		if (StringUtils.isEmpty(key)) {
			return null;
		}

		ServletContext servletCtx = PropertyHolder.getServletContext();
		Config config = (Config) servletCtx.getAttribute(key);
		if (config != null) {
			return config;
		} else {
			Config cfg = this.entityDao.getByKey(key);
			if (cfg != null) {
				servletCtx.setAttribute(key, cfg);
			}
			return cfg;
		}
	}

	public void clearServletCtxCachedConfig(String... keys) {
		if (keys != null && keys.length > 0) {
			ServletContext servletCtx = PropertyHolder.getServletContext();
			for (String key : keys) {
				servletCtx.removeAttribute(key);
			}
		}
	}

	public void deleteByKeys(final String... keys) {
		if (ArrayUtils.isNotEmpty(keys)) {
			this.entityDao.deleteByKeys(keys);
		}
	}

	@Transactional
	public void batchUpdate(List<Config> configList) {
		if (CollectionUtils.isNotEmpty(configList)) {
			List<String> keyList = Collections3.extractToList(configList, "key");
			deleteByKeys(keyList.toArray(new String[]{}));
			for (Config cfg : configList) {
				this.entityDao.insert(cfg);
			}
		}
	}

}
