package com.rocoinfo.rocomall.service.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.ProductSpecial;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.repository.ProductSpecialDao;
import com.rocoinfo.rocomall.service.IProductSpecialService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.ISkuService;

/**
 * @author zhangmin
 */
@SuppressWarnings("all")
@Service
public class ProductSpecialService extends CrudService<ProductSpecialDao, ProductSpecial> implements IProductSpecialService {

    @Autowired
    private ISkuService skuService;
    @Autowired
    private ICatalogService catalogService;

    public void buildDetail(ProductSpecial productSpecial) {
        Sku sku = skuService.getById(productSpecial.getSku().getId());
        skuService.buildDetail(sku);
        productSpecial.setSku(sku);
    }

    /**
     * @param catalogId      分类Id,如果不绑定到分类，则此参数传0
     * @param typeCodeParams 设置的商品类型编号
     */
    public ListMultimap<String, ProductSpecial> findSettingProductListMap(final long catalogId, ProductSpecialQueryParam... typeCodeParams) {
        ListMultimap settingProdListMap = ArrayListMultimap.create();
        if (ArrayUtils.isNotEmpty(typeCodeParams)) {
            Map<String, Object> paramMap = Maps.newHashMap();
            if (catalogId != 0) {
                paramMap.put("cid", catalogId);
            }
            paramMap.put("specialTypes", typeCodeParams);
            final List<ProductSpecial> specialProdList = this.entityDao.findSettingProdListByCateIdAndTypeCode(paramMap);
            if (!CollectionUtils.isEmpty(specialProdList)) {
                List<Sku> skuList = Lists.newArrayListWithExpectedSize(specialProdList.size());
                for (final ProductSpecial specialProd : specialProdList) {
                    settingProdListMap.put(specialProd.getType().getCode(), specialProd);
                    skuList.add(specialProd.getSku());
                }
                skuService.loadImages(skuList);
            }
        }
        return settingProdListMap;
    }

    /**
     * 根据type（skuId）查询
     *
     * @param params
     * @return
     */
    public List<ProductSpecial> findProdSepecialByParams(Map<String, Object> params) {
        return entityDao.findProdSepecialByParams(params);
    }
}