package com.rocoinfo.rocomall.service.impl.activity;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.entity.activity.ActivitySku;
import com.rocoinfo.rocomall.repository.activity.ActivitySkuDao;
import com.rocoinfo.rocomall.service.activity.IActivityService;
import com.rocoinfo.rocomall.service.activity.IActivitySkuService;
import com.rocoinfo.rocomall.service.product.ISkuService;

/**
 * 
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-11 下午5:59:08</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@Component
@Transactional
public class ActivitySkuService extends CrudService<ActivitySkuDao, ActivitySku> implements IActivitySkuService {

	@Autowired
	private ActivitySkuDao activitySkuDao;

	@Autowired
	private ISkuService skuService;
	@Autowired
	private IActivityService activityService;

	public void insert(ActivitySku activitySku) {
		activitySkuDao.insert(activitySku);
	}

	public List<ActivitySku> findByActivityId(Long activityId) {
		return activitySkuDao.getByActivityId(activityId);
	}

	public Map<Long, List<ActivitySku>> findListMapByActivityIdIn(List<Long> actIdList) {
		List<ActivitySku> activitySkuList = activitySkuDao.findWithSkuDetailByActivityIdIn(actIdList);
		if (CollectionUtils.isEmpty(activitySkuList)) {
			return Collections.emptyMap();
		}

		Map<Long, List<ActivitySku>> actSkuListMap = Maps.newHashMap();

		for (ActivitySku actSku : activitySkuList) {
			Long actId = actSku.getActivity().getId();

			List<ActivitySku> actSkuList = actSkuListMap.get(actId);
			if (actSkuList == null) {
				actSkuList = Lists.newArrayList();
				actSkuListMap.put(actId, actSkuList);
			}
			actSkuList.add(actSku);
		}

		return actSkuListMap;
	}

	public List<Long> findActivityIdBySkuIdAndActivityStatus(Long skuId, Activity.Status status) {
		return activitySkuDao.findActivityIdBySkuIdAndActivityStatus(skuId, status);
	}

	public void deleteByActivityId(Long activityId) {
		activitySkuDao.deleteByActivityId(activityId);
	}

	public List<ActivitySku> findDetailByActivityId(Long activityId) {
		List<ActivitySku> activitySkus = findByActivityId(activityId);
		if (!CollectionUtils.isEmpty(activitySkus)) {
			Activity act = activityService.getById(activityId);
			for (ActivitySku activitySku : activitySkus) {
				activitySku.setSku(skuService.getById(activitySku.getSku().getId()));
				skuService.buildDetail(activitySku.getSku());
				activitySku.setActivity(act);
			}
		}
		return activitySkus;
	}

	public List<Long> findListedActivityIdBySkuId(Long skuId) {
		return activitySkuDao.findListedActivityIdBySkuId(skuId);
	}

	public List<Long> findListedActivityIdBySkuIdIn(List<Long> skuIds) {
		return activitySkuDao.findListedActivityIdBySkuIdIn(skuIds);
	}

	public List<Long> findProductIdByActivityId(Long activityId) {
		return activitySkuDao.findProductIdByActivityId(activityId);
	}

	public List<ActivitySku> getSkusByActivityId(Long activityId) {
		return activitySkuDao.getSkusByActivityId(activityId);
	}

	public Long getTotalCentByActivityId(Long activityId) {
		return activitySkuDao.getTotalCentByActivityId(activityId);
	}

	public void increaseHitNumById(Long id) {
		activitySkuDao.increaseHitNumById(id);
	}

	/***
	 * 查询sku被活动独占的个数
	 * 
	 * @param skuId
	 * @return
	 */
	public List<Activity> getExclusiveActivityCountByskuId(Long skuId) {
		return activitySkuDao.getExclusiveActivityCountByskuId(skuId);
	};
}
