package com.rocoinfo.rocomall.service.impl.cent;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.repository.cent.CentRuleDao;
import com.rocoinfo.rocomall.service.cent.ICentRuleService;

/**
 * <dl>
 * <dd>描述: </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/28  上午11:54</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@Service
public class CentRuleService extends CrudService<CentRuleDao, CentRule> implements ICentRuleService {

    public CentRule getByCode(String code) {
        return entityDao.getByCode(code);
    }

    @Override
    public void switchStatus(Long id, CentRule.Status status) {
        CentRule centRule = new CentRule();
        centRule.setId(id);
        centRule.setStatus(status);
        this.update(centRule);
    }

    @Override
    public List<CentRule> findAllWithStatus(final CentRule.Status status) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("status", status);
        List<CentRule> list = this.findAll();
        if (status == null)
            return list;
        CollectionUtils.filter(list, new Predicate() {
            @Override
            public boolean evaluate(Object object) {
                CentRule centRule = (CentRule) object;
                return status.equals(centRule.getStatus());
            }
        });
        return list;
    }

}
