package com.rocoinfo.rocomall.service.impl.dict;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.DictAdvType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.redis.CacheKeys;
import com.rocoinfo.rocomall.repository.dict.DictAdvTypeDao;
import com.rocoinfo.rocomall.service.dict.IDictAdvTypeService;

@Service
public class DictAdvTypeService extends CrudService<DictAdvTypeDao, DictAdvType> implements IDictAdvTypeService {

	@Cacheable(value = CacheKeys.DEFAULT_NAME, key = CacheKeys.BANNER_TYPE_ALL_KEY)
	@Override
	public List<DictAdvType> findAll() {
		return super.findAll();
	}

	public boolean isExistCode(final String code) {
		if (StringUtils.isBlank(code)) {
			return false;
		}
		for (DictAdvType advType : getProxy().findAll()) {
			if (advType != null && advType.getCode().equalsIgnoreCase(code)) {
				return true;
			}
		}
		return false;
	}

	public boolean isExistName(final String name) {
		if (StringUtils.isBlank(name)) {
			return false;
		}
		for (DictAdvType advType : getProxy().findAll()) {
			if (advType != null && advType.getName().equalsIgnoreCase(name)) {
				return true;
			}
		}
		return false;
	}

	public void switchStatus(Long id, Status status) {
		DictAdvType advType = new DictAdvType();
		advType.setId(id);
		advType.setStatus(status);
		this.update(advType);
	}

	public List<DictAdvType> findByStatus(Status status) {
		List<DictAdvType> all = getProxy().findAll();
		if (status == null) {
			return all;
		}
		List<DictAdvType> filterAdvTypes = Lists.newArrayList();
		for (DictAdvType advType : all) {
			if (advType.getStatus() == status) {
				filterAdvTypes.add(advType);
			}
		}
		return filterAdvTypes;
	}

	@Override
	protected void evictCacheEntitysHook() {
		String key = StringUtils.substringBetween(CacheKeys.BANNER_TYPE_ALL_KEY, "'");
		Cache cache = cacheManager.getCache(CacheKeys.DEFAULT_NAME);
		cache.evict(key);
	}

	public DictAdvTypeService getProxy() {
		return (DictAdvTypeService) AopContext.currentProxy();
	}
}
