package com.rocoinfo.rocomall.service.impl.order;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.order.OrderItem.AdmStatus;
import com.rocoinfo.rocomall.entity.order.OrderItem.Status;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.repository.order.OrderOutStoreDao;
import com.rocoinfo.rocomall.service.impl.product.SkuService;
import com.rocoinfo.rocomall.service.order.IOrderOutStoreService;

/**
 * <dl>
 * <dd>描述:出库单Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月16日 上午10:41:44</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@Service
public class OrderOutStoreService extends CrudService<OrderOutStoreDao, OrderOutStore> implements IOrderOutStoreService {

	@Autowired
	private SkuService skuService;

	@Override
	public List<OrderOutStore> getMergeOrderOutStore(final long dictWarehouseId, final long dictExpressId, final String skuCode) {
		return super.entityDao.getMergeOrderOutStore(dictWarehouseId, dictExpressId, skuCode);
	}

	/**
	 * 搜索商品的出库记录
	 * 
	 * @param productId 产品Id
	 */
	public Page<OrderOutStore> searchOutstoreRecordsByProdId(Long productId, Pageable pageable) {
		List<OrderOutStore> pageData = Collections.emptyList();
		Long count = 0L;
		if (productId != null && productId > 0) {
			Map<String, Object> params = Maps.newHashMap();
			params.put("productId", productId);
			params.put(Constants.PAGE_OFFSET, pageable.getPageNumber());
			params.put(Constants.PAGE_SIZE, pageable.getPageSize());
			params.put(Constants.PAGE_SORT, pageable.getSort());

			count = this.entityDao.searchTotalOutstoreRecordsByProdId(params);
			if (count > 0) {
				pageData = entityDao.searchOutstoreRecordsByProdId(params);
			}
		}
		return new PageImpl<OrderOutStore>(pageData, pageable, count);
	}

	/**
	 * 出库操作
	 * 
	 * @param outStoreOrder
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED)
	public void execOutStore(OrderOutStore outStoreOrder) {
		//更新出库单状态
		entityDao.update(outStoreOrder);
		//更新子订单状态  内外状态
		this.upDateOrderItemStatus(Status.RECEIVING, AdmStatus.DISTRIBUTION_OUTED, outStoreOrder.getId());
		if (outStoreOrder.getState()) {
			//减少良品库存
			long skuId = outStoreOrder.getSku().getId();
			int quantity = -outStoreOrder.getQuantity();
			//FIXME TODO  减少库存前  商品数量有待验证
			skuService.incrOrDecrStock(skuId, quantity, null);
		}
	}

	@Override
	@Transactional(isolation = Isolation.READ_COMMITTED)
	public void upDateOrderItemStatus(Status outStatus, AdmStatus inStatus, Long id) {
		if(id == null || outStatus == null || inStatus == null)
			throw new ServiceException("子订单状态异常！");
		entityDao.upDateOrderItemStatus(outStatus,inStatus,id);
	}
}
