package com.rocoinfo.rocomall.service.impl.product;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.VirtualProduct;
import com.rocoinfo.rocomall.repository.VirtualProductDao;
import com.rocoinfo.rocomall.service.product.IVirtualProductService;

/**
 * <dl>
 * <dd>描述: 虚拟商品卡密管理Service实现</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/5 18:33</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
@Service
public class VirtualProductService extends CrudService<VirtualProductDao, VirtualProduct> implements IVirtualProductService {

	@Autowired
	private VirtualProductDao virtualProductDao;

	/**
	 * 统计卡密商品的sku编码和卡号或序列号在数据库中是否存在(存在的数量)
	 */
	public long countCardPwd(VirtualProduct virtualProduct) {
		return this.entityDao.countCardPwd(virtualProduct);
	}

	/**
	 * 统计兑换码商品,sku编码，兑换码是否存在(存在的数量)
	 */
	public long countExchangeCode(VirtualProduct virtualProduct) {
		return this.entityDao.countExchangeCode(virtualProduct);
	}
}
