package com.rocoinfo.rocomall.service.impl.wx;

import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.wx.WXUser;
import com.rocoinfo.rocomall.repository.wx.WxUserDao;
import com.rocoinfo.rocomall.service.wx.IWxUserService;

/**
 * <dl>
 * <dd>描述:微信用户服务</dd>
 * </dl>
 */
@Service
public class WxUserService extends CrudService<WxUserDao, WXUser> implements IWxUserService {

	public boolean isOpenIdExist(String openId) {
		return getWXUserByOpenId(openId) != null;
	}

	public boolean isWxUserBounded(String openId) {
		WXUser wxUser = getWXUserByOpenId(openId);
		return wxUser != null && wxUser.isBounded();
	}

	public WXUser getWXUserByOpenId(String openId) {
		return this.entityDao.getWXUserByOpenId(openId);
	}

	public WXUser getWXUserByUserId(Long userId) {
		return this.entityDao.getWXUserByUserId(userId);
	}
}
