package com.rocoinfo.rocomall.service.insurance;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;

/**
 * <dl>
 * <dd>描述:被保险人或投保人信息对应的Service层</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/12/29 15:51</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
public interface IInsuredInfoService extends IBaseService<InsuredInfo> {

    /**
     * 根据手机号码或者openid获取用户信息
     *
     * @param param 参数(手机号码 openid)
     * @return 用户信息
     */
    InsuredInfo getByMobileOrOpenid(String param);

    /**
     * 根据登录用户的id查找登录用户所关联的用户(投保人和被保险人)信息
     *
     * @param id 用户id
     * @return 用户所关联的用户(投保人和被保险人)信息
     */
    List<InsuredInfo> findByRelationId(Long id);

    /**
     * 创建投保人账户(用户名为手机号或者openid),账户信息关联投保人信息
     *
     * @param id       投保人id
     * @param username 用户名(手机号或者openid)
     */
    void createUserInfo(Long id, String username);

    /**
     * 创建用户之间的关联关系(保险人与登录用户之间 N:1)
     *
     * @param loginUser    登录用户(一般为投保人)
     * @param RelationUser 关联用户
     * @param isLogin      用户是否登录
     */
    void createUserRelationship(InsuredInfo loginUser, InsuredInfo RelationUser, boolean isLogin);

    /**
     * 更新或保存(通过证件号码校验用户是否存在)
     *
     * @param insuredInfo
     */
    void saveOrUpdate(InsuredInfo insuredInfo);

    /**
     * 根据证件号码查询用户
     *
     * @param cardNo 证件号码
     * @return
     */
    InsuredInfo getByCardNo(String cardNo);

    /**
     * 校验投保人与被保险人是否存在关联关系
     *
     * @param insuredId  投保人id
     * @param relationId 被保险人id
     * @return
     */
    boolean hasRelation(Long insuredId, Long relationId);

    /**
     * 在系统中创建新的账号(账号为openid或者手机号)
     * 需要现在系统中检测此账号是否存在,如果存在,则不进行操作
     * 如果不存在,则插入相应的用户,并创建相应的账号
     *
     * @param insuredInfo 用户信息
     * @param username    用户名
     */
    void createNewAccount(InsuredInfo insuredInfo, String username);
}
