package com.rocoinfo.rocomall.service.product;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.ProdTemp;
import com.rocoinfo.rocomall.entity.Product;

/**
 * 
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-7-31 下午6:21:25</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public interface IProductService extends IBaseService<Product> {

	/**
	 * 创建商品
	 * 
	 * @创建时间：2015-7-31 下午6:22:33
	 */
	public void create(Product product, Long userId);

	/**
	 * 保存零时商品数据
	 */
	public Long createTemp(String jsonStr, Long userId);

	/**
	 * 更新商品
	 * 
	 * @创建时间：2015-7-31 下午6:22:41
	 */
	public void update(Product product, Long userId);

	/**
	 * 更新零时商品数据
	 * 
	 * @创建时间：2015-7-31 下午6:22:41
	 */
	public void updateTemp(String jsonStr, Long id);

	// 弃用
	public void discard(long id, Long userId);

	// 提交审核
	public void submitAudit(Long id, Long userId);

	// 审核拒绝
	public void auditRefuse(Long id, Long userId);

	// 审核通过
	public void auditOk(Long id, Long userId);

	// 上架
	public void list(Long id, Long userId) throws Exception;

	// 下架
	public void delist(Long id, Long userId);

	// 建立详情
	public void buildDetail(Product product);

	public ProdTemp getLastProdTempByUserId(Long userId);

	public List<Long> scheduleList();

	public List<Long> scheduleDelist();

	// 维护是否在列表页显示状态
	void updateIsInListStatus(Long productId);

}
