package com.rocoinfo.rocomall.service.product;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.SkuCentDiscountDto;
import com.rocoinfo.rocomall.entity.Sku;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-3 上午11:01:00</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public interface ISkuService extends IBaseService<Sku> {

	/**
	 * 查询出所有上架的sku,包括sku的Product信息，图片、所属分类(用来在列表页生成js文件)
	 */
	List<Sku> findAllListedSkuWithProdCatalogAndImgs();

	Long getSkuIdByAttributes(Long productId, String attribute1, String attribute2, String attribute3);

	void update(Sku sku, Long userId);

	/**
	 * 增加/减少 占用库存
	 * 
	 * @param skuIdList
	 * @param qtyList 数量>0 表示增加, 数量<0则表示减少
	 */
	void incrOrDecrOccupiedStock(final List<Long> skuIdList, final List<Integer> qtyList);

	/**
	 * 增加|减少 良品库存
	 * 
	 * @param quantity>0,则表示添加库存，否则减少库存
	 * @param dictWareHouseId 仓库Id,如果是出库时，则传null,入库传仓库id
	 */
	void incrOrDecrStock(@Param("skuId") Long skuId, @Param("quantity") Integer quantity, @Param("wareHouseId") Long dictWareHouseId);

	/**
	 * 支付的订单被取消后, 较少占用库存 & 较少销量
	 */
	@Deprecated
	void decreaseOccupiedStockAndSaleVolumeOnCancel(final long skuId, final int quantity);

	/**
	 * 支付成功后，增加占用库存 & 增加销量
	 */
	@Deprecated
	void batchIncreaseOccupiedStockAndSaleVolumeOnPayed(final List<Long> skuIdList, final List<Integer> quantityList);

	/**
	 * 发货时, 较少占用库存 & 减少良品库存
	 */
	@Deprecated
	void decreaseStockAndOccupiedOnSend(final long skuId, final int quantity);

	/**
	 * 换货时,如果选择选择原商品不可用， 良品库存减少 & 残次品库存增加
	 */
	@Deprecated
	void decrStockAndIncrDefectStockOnExchange(final long skuId, final int quantity);

	/**
	 * 退货时,如果选择原商品可用, 则商品良品库存增加
	 */
	@Deprecated
	void increaseStockOnRefundIfCanUse(final long skuId, final int quantity);

	/**
	 * 批量导入发货时, 较少占用库存 & 减少良品库存
	 */
	@Deprecated
	void batchDecreaseStockAndOccupiedOnImport(final List<Long> skuIdList, final List<Integer> quantityList);

	void loadImages(List<Sku> skuList);

	void buildDetail(Sku sku);

	Sku buildDetail(Long skuId, boolean isLoadImg);

	/**
	 * 根据编码查询Sku
	 */
	Sku getByCode(String skuCode);

	/**
	 * 是否虚拟商品
	 */
	boolean isVirtualProduct(Long skuId);

	/**
	 * 批量清除缓存
	 */
	void batchClearCachedSkus(List<Long> skuIdList);

	/**
	 * 获得sku列表（包括sku的商品，和图片）
	 * 
	 * @param skuIds
	 * @param isLoadSkuImg
	 * @return
	 */
	List<Sku> findSkuWithProdByIdIn(List<Long> skuIds, boolean isLoadSkuImg);

	void buildCartSkuDetail(Sku sku);

	List<SkuCentDiscountDto> findSkuCentAndDicountByIdIn(List<Long> skuIds);
}
