package com.rocoinfo.rocomall.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.redis.CacheKeys;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.service.ISequenceService;
import com.rocoinfo.rocomall.service.impl.SequenceService.SequenceTable;

/**
 * @author zhangmin
 */
@Component
public class CodeGenerator {

	@Autowired
	private JedisTemplate jedisTemplate;
	@Autowired
	private ISequenceService sequenceService;
	private static final SimpleDateFormat ymdHmsFormat = new SimpleDateFormat("yyMMddHHmmss");
	private static final SimpleDateFormat ymdHmFormat = new SimpleDateFormat("yyMMddHHmm");
	private static final SimpleDateFormat ymdFormat = new SimpleDateFormat("yyMMdd");

	/**
	 * 生成访问token (7位字母 + 1位数字)
	 */
	public static String generateAccessToken() {
		StringBuilder tokenBuf = new StringBuilder();
		tokenBuf.append(RandomTools.getRandStr(7, 1)).append(RandomTools.getRandStr(1, 2));
		return tokenBuf.toString();
	}

	public static String generateWxMessageId() {
		String dateTimePrefix = ymdHmsFormat.format(new Date());
		String randomNum = RandomTools.getRandStr(5, 2);
		return dateTimePrefix + randomNum;
	}

	/**
	 * 生成积分计划code
	 */
	public String generateDictPlanCode() {
		return generateTableCode(SequenceTable.DICT_PLAN);
	}

	public String generateDictAdvTypeCode() {
		return generateTableCode(SequenceTable.ADV_TYPE);
	}

	/**
	 * 生成积分规则code
	 */
	public String generateCentRuleCode() {
		return generateTableCode(SequenceTable.CENT_RULE);
	}

	private String generateTableCode(SequenceTable seqTab) {
		int nextSeq = sequenceService.getNextVal(seqTab);
		if (seqTab.getFixWidth() > 0) {
			return StringUtils.leftPad(String.valueOf(nextSeq), seqTab.getFixWidth(), '0');
		}
		return String.valueOf(nextSeq);
	}

	/**
	 * 生成积分申请编号
	 */
	public String generateCentApplyCode() {
		return System.currentTimeMillis() + RandomTools.getRandStr(5, 2);
	}

	/**
	 * 积分编码：规则code+yyMMdd+7为序号
	 */
	public String generateCentCode(CentRule rule) {
		StringBuilder sb = new StringBuilder();
		sb.append(rule.getCode());
		final String datePart = ymdFormat.format(new Date());
		sb.append(datePart);

		final String centCodeSeqKey = CacheKeys.ORDER_CODE_SEQ_PREFIX + datePart;
		Long seq = jedisTemplate.incr(centCodeSeqKey);
		if (seq == 1) {
			jedisTemplate.expire(centCodeSeqKey, DateUtil.SECONDS_PER_DAY);
		}
		String seqPart = StringUtils.leftPad(String.valueOf(seq), 7, '0');
		sb.append(seqPart);
		return sb.toString();
	}

	//    /**
	//     * 生成积分消耗流水号 :积分消耗类型  +  yyMMdd + 1天内的流水 + 2位随机数
	//     */
	//    public String generateCentConsumeSnNum(Date dateTime,String consumeTypeCode){
	//		final String prefix = consumeTypeCode;
	//
	//		final String datePart =  ymdFormat.format(dateTime);
	//
	//		final String orderSeqKey = CacheKeys.CONSUME_SN_PREFIX + datePart;
	//
	//		Long seq = jedisTemplate.incr(orderSeqKey);
	//
	//		//如果是这分钟内第一次，则设置可以的有效期为120秒
	//		if (seq == 1) {
	//			jedisTemplate.expire(orderSeqKey, DateUtil.SECONDS_PER_DAY);
	//		}
	//		String seqPart = StringUtils.leftPad(String.valueOf(seq), 7, '0');
	//		StringBuilder sb = new StringBuilder();
	//		sb.append(prefix).append(datePart).append(seqPart)
	//		.append(RandomTools.getRandStr(2, 2));
	//		return sb.toString();
	//    }
	//

	/**
	 * 生成入出库申请单号：格式：I/O+yyMMddHHmm+7位随机数字 add by liuyu
	 * 
	 * @param inStock true=>入库单申请， false=>出库单申请
	 */
	public static String generateStockApplyCode(boolean inStock) {
		String prefix = inStock ? "I" : "O";
		String timePart = ymdHmFormat.format(new Date());
		StringBuilder sb = new StringBuilder();
		sb.append(prefix).append(timePart).append(RandomTools.getRandStr(7, 2));
		return sb.toString();
	}

	/**
	 * 生成积分预算编码：格式：BUD+yyMMddHHmm+7位随机数字
	 */
	public String generateBudgetCode() {
		String prefix = "BUD";
		String timePart = ymdHmFormat.format(new Date());
		StringBuilder sb = new StringBuilder();
		sb.append(prefix).append(timePart).append(RandomTools.getRandStr(7, 2));
		return sb.toString();
	}

	//	/**
	//	 * 生成主订单号：格式：2位订单类型code + yyMMdd+2位随机数 + 1天内的订单序号
	//	 */
	//	public String generateOrderCode(Date dateTime, OrderType orderType) {
	//
	//		final String prefix = orderType.getCode();
	//
	//		final String datePart =  ymdFormat.format(dateTime);
	//
	//		final String orderSeqKey = CacheKeys.ORDER_CODE_SEQ_PREFIX + datePart;
	//
	//		Long seq = jedisTemplate.incr(orderSeqKey);
	//
	//		//如果是这分钟内第一次，则设置可以的有效期为120秒
	//		if (seq == 1) {
	//			jedisTemplate.expire(orderSeqKey, DateUtil.SECONDS_PER_DAY);
	//		}
	//		String seqPart = StringUtils.leftPad(String.valueOf(seq), 4, '0');
	//		StringBuilder sb = new StringBuilder();
	//		sb.append(prefix).append(datePart).append(RandomTools.getRandStr(2, 2)).append(seqPart);
	//		return sb.toString();
	//	}

	/**
	 * 用户导入时 生成随机编号
	 * 
	 * @return
	 */
	public static String generateUserImportApplyCode() {
		return System.currentTimeMillis() + RandomTools.getRandStr(5, 2);
	}

	/**
	 * 生成积分规则秘钥
	 * 
	 * @return
	 */
	public static String generateSecurityKey() {
		String currentTime = System.currentTimeMillis() + "";
		return DigestUtils.md5Hex(currentTime.substring(0, currentTime.length() - 3).getBytes());
	}

	/**
	 * 生成退积分序号
	 * 
	 * @param dateTime
	 * @param consumeTypeCode
	 * @return
	 */
	public String generateCentConsumeSnNum(Date dateTime, String consumeTypeCode) {
		final String prefix = consumeTypeCode;
		final String datePart = ymdFormat.format(dateTime);
		final String orderSeqKey = CacheKeys.CONSUME_SN_PREFIX + datePart;
		Long seq = jedisTemplate.incr(orderSeqKey);

		//如果是这分钟内第一次，则设置可以的有效期为120秒
		if (seq == 1) {
			jedisTemplate.expire(orderSeqKey, DateUtil.SECONDS_PER_DAY);
		}
		String seqPart = StringUtils.leftPad(String.valueOf(seq), 7, '0');
		StringBuilder sb = new StringBuilder();
		sb.append(prefix).append(datePart).append(seqPart).append(RandomTools.getRandStr(2, 2));
		return sb.toString();
	}

	/**
	 * 生成主订单号：格式：2位订单类型code + yyMMdd+2位随机数 + 1天内的订单序号
	 */
	public String generateOrderCode(Date dateTime, OrderItem.OrderType orderType) {

		final String prefix = orderType.getCode();

		final String datePart = ymdFormat.format(dateTime);

		final String orderSeqKey = CacheKeys.ORDER_CODE_SEQ_PREFIX + datePart;

		Long seq = jedisTemplate.incr(orderSeqKey);

		//如果是这分钟内第一次，则设置可以的有效期为120秒
		if (seq == 1) {
			jedisTemplate.expire(orderSeqKey, DateUtil.SECONDS_PER_DAY);
		}
		String seqPart = StringUtils.leftPad(String.valueOf(seq), 4, '0');
		StringBuilder sb = new StringBuilder();
		sb.append(prefix).append(datePart).append(RandomTools.getRandStr(2, 2)).append(seqPart);
		return sb.toString();
	}

	/**
	 * 生成入库单号
	 * 
	 * @return
	 */
	public String generateInstoreOrderCode() {
		return generateTableCode(SequenceTable.INSTORE_CODE);
	}

	/**
	 * 生成配送单号:P+yyMMddHHmm + 子订单后4位 + 3位随机数字
	 */
	public String generateDistributionOrderCode(String subOrderCode) {
		StringBuilder codeBuilder = new StringBuilder();
		codeBuilder.append("P");
		final String datePart = ymdHmFormat.format(new Date());
		codeBuilder.append(datePart);
		//子订单后4位
		codeBuilder.append(subOrderCode.substring(subOrderCode.length() - 4));
		codeBuilder.append(RandomTools.getRandStr(3, 2));
		return codeBuilder.toString();
	}

	/**
	 * 生成出库单号
	 */
	public String generateOutstoreOrderCode() {
		StringBuilder codeBuilder = new StringBuilder();
		codeBuilder.append("O");
		final String datePart = ymdHmFormat.format(new Date());
		codeBuilder.append(datePart);
		codeBuilder.append(RandomTools.getRandStr(4, 2));
		return codeBuilder.toString();
	}

	/**
	 * 生成工单号 yyMMddHHmm + 2位随机 + 001
	 */
	public String generateWorkOrderCode() {
		String currDate = ymdHmFormat.format(new Date());
		String key = currDate;
		long num = jedisTemplate.incr(key);
		if (num <= 1) {
			jedisTemplate.expire(key, 24 * 60 * 60 * 1000);
		}
		String randPart = RandomTools.getRandStr(2, 2);
		String seqPart = StringUtils.leftPad(String.valueOf(num), 3, '0');
		return currDate + randPart + seqPart;
	}

	/**
	 * 生成积分规则code
	 */
	public String generateCompanyCode() {
		return generateTableCode(SequenceTable.COMPANY_CODE);
	}
}
