package com.rocoinfo.rocomall.utils;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;

import com.rocoinfo.rocomall.pay.wechat.WxSignUtil;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.SSLContext;

public class RestTemplateUtil {
    private static Logger logger = LoggerFactory.getLogger(RestTemplateUtil.class);
    private static RestTemplate restTemplateUtf8 = null;

    private static RestTemplate restTemplateGBK = null;

    private static RestTemplate restTemplateUtf8Https = null;

    /**
     * 获取StringHttpMessageConverter 编码集为utf-8的template
     *
     * @return
     */
    public static RestTemplate getRestTemplateGBK() {
        if (restTemplateGBK == null) {
            synchronized (RestTemplateUtil.class) {
                if (restTemplateGBK == null) {
                    restTemplateGBK = getRestTemplate(null, null, false,"GBK");
                }
            }
        }
        return restTemplateGBK;
    }

    /**
     * 获取StringHttpMessageConverter 编码集为utf-8的template
     *
     * @return
     */
    public static RestTemplate getRestTemplateUtf8() {
        if (restTemplateUtf8 == null) {
            synchronized (RestTemplateUtil.class) {
                if (restTemplateUtf8 == null) {
                    restTemplateUtf8 = getRestTemplate(null, null, false,"utf-8");
                }
            }
        }
        return restTemplateUtf8;
    }


    /**
     * 获取StringHttpMessageConverter 编码集为utf-8的template
     *
     * @return
     */
    public static RestTemplate getRestTemplateUtf8Https(String password, String path)   {
        if (restTemplateUtf8Https == null) {
            synchronized (RestTemplateUtil.class) {
                if (restTemplateUtf8Https == null) {
                    restTemplateUtf8Https = getRestTemplate(password, path, true,"utf-8");
                }
            }
        }
        return restTemplateUtf8Https;
    }

    /**
     * 获取StringHttpMessageConverter 编码集为utf-8的template
     *
     * @return
     */
    private static RestTemplate getRestTemplate(String password, String path, boolean isHttps,String charset) {
        RestTemplate template = null;
        if (isHttps) {
            template = new RestTemplate(new HttpComponentsClientHttpRequestFactory((getHttpsClient(password, path))));
        } else {
            template = new RestTemplate(new HttpComponentsClientHttpRequestFactory(HttpUtils.createHttpClientInstance()));
        }
        ClientHttpRequestFactory f = template.getRequestFactory();
        if (f instanceof HttpComponentsClientHttpRequestFactory) {
            HttpComponentsClientHttpRequestFactory fh = (HttpComponentsClientHttpRequestFactory) f;
            fh.setConnectTimeout(6000);
            fh.setReadTimeout(6000);
        }

        List<HttpMessageConverter<?>> messageConverters = template.getMessageConverters();
        List<HttpMessageConverter<?>> newMessageConverters = new ArrayList<HttpMessageConverter<?>>(messageConverters.size());
        for (HttpMessageConverter<?> converter : messageConverters) {
            if (converter instanceof StringHttpMessageConverter) {
                newMessageConverters.add(new StringHttpMessageConverter(Charset.forName(charset)));
                continue;
            }
            newMessageConverters.add(converter);
        }
        template.setMessageConverters(newMessageConverters);
        return template;
    }

    public static HttpClient getHttpsClient(String password, String path) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream instream = new FileInputStream(new File(path));
            try {
                keyStore.load(instream, password.toCharArray());
            } finally {
                instream.close();
            }
            // Trust own CA and all self-signed certs
            SSLContext sslcontext = SSLContexts.custom()
                    .loadKeyMaterial(keyStore, password.toCharArray())
                    .build();
            // Allow TLSv1 protocol only
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
                    sslcontext,
                    new String[]{"TLSv1"},
                    null,
                    SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            CloseableHttpClient httpclient = HttpClients.custom()
                    .setSSLSocketFactory(sslsf)
                    .build();
            return httpclient;
        } catch ( Exception e ) {
            e.printStackTrace();
            logger.error("getHttpsClient error{},",e.getMessage());
            return null;
        }
    }
}
