DROP TABLE IF EXISTS prod_virtualproduct;
DROP TABLE IF EXISTS cardpwd_deliver_record;

alter table sales_order_item add vptype varchar(20) COMMENT '虚拟商品类型';

CREATE TABLE prod_virtualproduct (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  sku_code varchar(64) NOT NULL COMMENT '商品编码',
  cardno varchar(50) COMMENT '卡号',
  passwd varchar(50) COMMENT '密码',
  expired datetime COMMENT '有效期',
  vp_status varchar(20) COMMENT '状态',
  vp_type varchar(20) COMMENT '类型',
  remark varchar(100) COMMENT '备注',
  serialno varchar(50) COMMENT '序列号',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

create table cardpwd_deliver_record(
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  orderitem_id int(11) NOT NULL COMMENT '子订单id',
  virtualproduct_id int(11) NOT NULL COMMENT '虚拟商品id',
  create_time datetime COMMENT '记录时间',
  deliver_status VARCHAR(10) COMMENT '发货状态:初始,成功,失败',
  content VARCHAR(100) COMMENT '发送内容',
  user_id int(11) COMMENT '用户id',
  operator_id int(11) COMMENT '操作员id',
  PRIMARY KEY (id)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;


alter table prod_catalog  add  wap_index_img varchar(300)   DEFAULT NULL COMMENT 'wap首页图标';