package com.rocoinfo.rocomall;

/**
 * 微信接口url地址
 */
public interface WeiXinInterfaceUrl {

	/**
	 * 获取访问token url
	 **/
	public static final String GET_ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";

	/***
	 * 创建自定义menu
	 */
	public static final String WX_MENU_CREATE = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=%s";

	/***
	 * 根据OpenID获取用户基本信息 基本信息包括昵称、头像、性别、所在城市、语言和关注时间
	 */
	public static final String WX_USER_INFO = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s";

	/***
	 * 人工主动发送客服消息【下发/群发】 http请求方式: POST
	 */
	public static final String SEND_MSG_URL = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=%s";

	/***
	 * 多媒体下载接口
	 */
	public static final String MEDIA_DOWNLOAD_URL = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=%s&media_id=%s";

	//  =============微信  JS-SDK 相关接口 =========

	/**
	 * jsapi_ticket是公众号用于调用微信JS接口的临时票据
	 */
	public static final String JSAPI_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";

	//  =============  公司物流接口地址 =========

	/***
	 * 查询物流信息 接口地址
	 */
	public static final String LOGISTIC_URL = "http://logistics.rocoinfo.com/Default.aspx?LogisticsName=%s&LogisticsCode=%s";

	/**
	 * 红包发放url
	 */
	public static final String SEND_RED_PACK = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
}
