package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.enumconst.CacheableTag;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.redis.CacheKeys;

/**
 * 商品品牌
 * 
 * @author yangxc
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@CacheableTag(cacheKeyPrev = CacheKeys.BRAND_KEY_PREV)
public class Brand extends IdEntity {

	private static final long serialVersionUID = 4199785561993679881L;

	/**
	 * 品牌名称
	 */
	private String name;

	/**
	 * 品牌英文名称
	 */
	private String englishName;

	/**
	 * 图片路径
	 */
	@JsonIgnore
	private String imagePath;

	/**
	 * 显示顺序
	 */
	private Integer displayOrder;

	/**
	 * 状态
	 */
	private Status status;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getEnglishName() {
		return englishName;
	}

	public void setEnglishName(String englishName) {
		this.englishName = englishName;
	}

	public String getImagePath() {
		return imagePath;
	}

	public void setImagePath(String imagePath) {
		this.imagePath = imagePath;
	}

	public Integer getDisplayOrder() {
		return displayOrder;
	}

	public void setDisplayOrder(Integer displayOrder) {
		this.displayOrder = displayOrder;
	}

	public String getFullImageUrl() {
		return PropertyHolder.getFullImageUrl(this.getImagePath());
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}
}
