package com.rocoinfo.rocomall.entity;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.order.OrderItem;

/**
 * 订单状态流转操作日志
 *
 * @author zhangmin
 */
public class OrderItemOperationLog extends IdEntity {
    /**
     */
    private static final long serialVersionUID = 9095330584435487881L;

    private OrderItem orderItem;

    private AdminUser operator;

    private String operation;

    /**
     * 操作说明备注
     */
    private String note;

    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
    private Date logTime;

    public OrderItem getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    public AdminUser getOperator() {
        return operator;
    }

    public void setOperator(AdminUser operator) {
        this.operator = operator;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Date getLogTime() {
        return logTime;
    }

    public void setLogTime(Date logTime) {
        this.logTime = logTime;
    }
}