package com.rocoinfo.rocomall.entity;

import java.util.List;

import org.springframework.data.annotation.Transient;

import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.cent.Apply;
import com.rocoinfo.rocomall.entity.cent.Approve;

/**
 * @author zhangmin
 */
public class ProdStockApply extends Apply {

    private static final long serialVersionUID = -9098213861366456115L;

    private Boolean visual;

    private WareHouse warehouse;

    private User approver;

    private Approve.ApproveResult result;

    private String notation;

    private StockType type;

    @Transient
    private List<ProdStockApplyItem> prodStockApplyItems;

    @Transient
    private List<StockApprove> stockApproveList;

    public enum StockType {

        IN("入库"), OUT("出库");

        private final String label;

        StockType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    public StockType getType() {
        return type;
    }

    public void setType(StockType type) {
        this.type = type;
    }

    public enum WareHouse {

        GOOD("良品库"), VISUAL("虚拟库");

        private final String label;

        WareHouse(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    public Boolean getVisual() {
        return visual;
    }

    public void setVisual(Boolean visual) {
        this.visual = visual;
    }

    public WareHouse getWarehouse() {
        return warehouse;
    }

    public void setWarehouse(WareHouse warehouse) {
        this.warehouse = warehouse;
    }

    public User getApprover() {
        return approver;
    }

    public void setApprover(User approver) {
        this.approver = approver;
    }

    public Approve.ApproveResult getResult() {
        return result;
    }

    public void setResult(Approve.ApproveResult result) {
        this.result = result;
    }

    public String getNotation() {
        return notation;
    }

    public void setNotation(String notation) {
        this.notation = notation;
    }

    public List<StockApprove> getStockApproveList() {
        return stockApproveList;
    }

    public void setStockApproveList(List<StockApprove> stockApproveList) {
        this.stockApproveList = stockApproveList;
    }

    public List<ProdStockApplyItem> getProdStockApplyItems() {
        return prodStockApplyItems;
    }

    public void setProdStockApplyItems(List<ProdStockApplyItem> prodStockApplyItems) {
        this.prodStockApplyItems = prodStockApplyItems;
    }
}
