package com.rocoinfo.rocomall.entity.account;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.map.ListOrderedMap;
import org.springside.modules.utils.Collections3;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Maps;

/**
 * @author liuwei
 */
@SuppressWarnings("all")
public class Permission {

	public static final String PRODUCT_VIEW_ROCO = "product:view:roco";
	public static final String PRODUCT_VIEW_JJ = "product:view:JJ";
	public static final String ORDER_VIEW_ROCO = "order:view:roco";
	public static final String ORDER_VIEW_JJ = "order:view:JJ";
	public static final String ACTIVITY_VIEW_ROCO = "activity:view:roco";
	public static final String ACTIVITY_VIEW_JJ = "activity:view:JJ";

	// 上面的权限值 将来要删除掉

	// 访问管理后台主页的权限
	public static final String ADMIN_HOME = "admin-home";

	public static final String ORDER_VIEW = "order:list:view";
	public static final String ORDER_EXPORT = "order:export";
	public static final String ORDER_IMPORT = "order:import";
	public static final String ORDER_CANCEL = "order:cancel";
	public static final String ORDER_DEAL = "order:deal";
	public static final String ORDER_MODIFYEXPRESS = "order:modifyExpress";
	public static final String ORDER_CONFIRMSUCCESS = "order:confirmSuccess";
	public static final String ORDER_SEND = "order:send";
	public static final String ORDER_REFUND = "order:REFUND";
	public static final String ORDER_EXCHANGE = "order:EXCHANGE";
	public static final String ORDER_CONFIRMREFUND = "order:confirmRefund";
	public static final String ORDER_CONFIRMEXCHANGE = "order:confirmExchange";

	public static final String ACTIVITY_VIEW = "activity:list:view";
	public static final String ACTIVITY_ADD = "activity:add";
	public static final String ACTIVITY_EDIT = "activity:edit";
	public static final String ACTIVITY_AUDIT = "activity:audit";
	public static final String ACTIVITY_REFUSE = "activity:refuse";
	public static final String ACTIVITY_READY_LIST = "activity:ready:list";
	public static final String ACTIVITY_LIST = "activity:list";
	public static final String ACTIVITY_DELIST = "activity:delist";
	public static final String ACTIVITY_DISCARD = "activity:discard";

	public static final String USER_VIEW = "user:list:view";
	public static final String USER_ADD = "user:add";
	public static final String USER_FORBIDDEN = "user:forbidden";
	public static final String USER_IMPORT_BTN = "user:import:btn";
	public static final String USER_ADD_BTN = "user:add:btn";

	public static final String USERAPPLY_VIEW = "userapply:list:view";
	public static final String USERAPPLY_SUBMIT = "userapply:submitaudit";
	public static final String USERAPPLY_AUDIT = "userapply:audit";

	public static final String SKU_VIEW = "sku:list:view";

	public static final String PRODUCT_VIEW = "product:list:view";
	public static final String PRODUCT_ADD = "product:add";
	public static final String PRODUCT_EDIT = "product:edit";
	public static final String PRODUCT_DISCARD = "product:discard";
	public static final String PRODUCT_SUBMITAUDIT = "product:submitAudit";
	public static final String PRODUCT_AUDITREFUSE = "product:auditRefuse";
	public static final String PRODUCT_AUDITOK = "product:auditOk";
	public static final String PRODUCT_DELIST = "product:deList";
	public static final String PRODUCT_LIST = "product:list";

	public static final String CATALOG_VIEW = "catalog:list:view";

	public static final String AUCTION_VIEW = "auction:list:view";

	public static final String ROLE_VIEW = "role:list:view";

	public static final String SUPPLIER_VIEW = "supplier:list:view";

	public static final String BRAND_VIEW = "brand:list:view";

	public static final String USERLEVEL_VIEW = "userlevel:list:view";
	public static final String USERLEVEL_CREATE = "userlevel:create";
	public static final String USERLEVEL_DELETE = "userlevel:delete";
	public static final String USERLEVEL_EDIT = "userlevel:edit";

	public static final String PRODSTOCK_VIEW = "prodstock:list:view";
	public static final String PRODSTOCK_IN = "prodstock:in";
	public static final String PRODSTOCK_OUT = "prodstock:out";
	public static final String PRODSTOCK_EDIT = "prodstock:edit";
	public static final String PRODSTOCK_AUDIT = "prodstock:audit";

	public static final String ADV_VIEW = "adv:list:view";

	public static final String SETT_VIEW = "sett:list:view";

	public static final String CENTBUDGET_VIEW = "centbudget:list:view";
	public static final String CENTBUDGET_ADD = "centbudget:add";
	public static final String CENTBUDGET_EDIT = "centbudget:edit";
	public static final String CENTBUDGET_DELETE = "centbudget:delete";

	public static final String CENTS_VIEW = "cents:list:view";
	public static final String CENTS_ADDAPPLY = "cents:addapply";
	public static final String CENTS_SUBAPPLY = "cents:subapply";

	public static final String CENTRULE_VIEW = "centrule:list:view";
	public static final String CENTRULE_CREATE = "centrule:create";
	public static final String CENTRULE_DELETE = "centrule:delete";
	public static final String CENTRULE_EDIT = "centrule:edit";

	public static final String CENTIMPORT_VIEW = "centimport:list:view";
	public static final String CENTIMPORT_IMPORT = "centimport:import";
	public static final String CENTIMPORT_EDIT = "centimport:edit";
	public static final String CENTIMPORT_SUBMITAUDIT = "centimport:submitaudit";
	public static final String CENTIMPORT_AUDIT = "centimport:audit";
	public static final String CENTIMPORT_DELETE = "centimport:delete";

	public static final String CENTPLAN_VIEW = "centplan:list:view";
	public static final String CENTPLAN_ADD = "centplan:add";
	public static final String CENTPLAN_EDIT = "centplan:edit";
	public static final String CENTPLAN_PLANRULE = "centplan:planrule";

	public static final String CENTCONSUME_VIEW = "centconsume:list:view";

	public static final String ADMINMGR_VIEW = "adminmgr:list:view";

	public static final String EXPRESS_VIEW = "express:list:view";
	public static final String PLATFORM_VIEW = "platform:list:view";
	public static final String DEPARTMENT_VIEW = "department:list:view";
	public static final String CENTCONSUMEDICT_VIEW = "centconsumedict:list:view";
	// 系统设置字典
	public static final String SYSTEMSETTINGSDICT_VIEW = "systemsettingsdict:list:view";

	// 虚拟商品卡密管理
	public static final String VIRTUALPRODUCT_VIEW = "virtualproduct:list:view";
	public static final String VIRTUALPRODUCT_ADD = "virtualproduct:add";
	public static final String VIRTUALPRODUCT_EDIT = "virtualproduct:edit";
	public static final String VIRTUALPRODUCT_DELETE = "virtualproduct:del";
	public static final String VIRTUALPRODUCT_IMPORT = "virtualproduct:import";

	// 商品退换货管理
	public static final String PROD_RETURN_VIEW = "prodreturn:list:view";

	// TODO 后续调整
    @JsonFormat(shape = JsonFormat.Shape.OBJECT)
	public static enum Permissions {
		ALL("*", "最高权限", false), ADMIN_HOME(Permission.ADMIN_HOME, "访问主页", true), USER_VIEW(Permission.USER_VIEW, "会员管理", true), USER_ADD_BTN(Permission.USER_ADD_BTN, "会员新增", true), USER_IMPORT_BTN(Permission.USER_IMPORT_BTN, "会员导入", true), USER_ADD(Permission.USER_ADD, "会员管理:启用", true), USER_FORBIDDEN(Permission.USER_FORBIDDEN, "会员管理:禁用", true), USERAPPLY_VIEW(Permission.USERAPPLY_VIEW, "会员审批", true), USERAPPLY_SUBMIT(Permission.USERAPPLY_SUBMIT, "提交审批", true), USERAPPLY_AUDIT(Permission.USERAPPLY_AUDIT, "审批处理", true), ACTIVITY_VIEW(Permission.ACTIVITY_VIEW, "活动管理", true), ACTIVITY_ADD(Permission.ACTIVITY_ADD, "活动管理:添加", true), ACTIVITY_EDIT(Permission.ACTIVITY_EDIT, "活动管理:编辑", true), ACTIVITY_AUDIT(Permission.ACTIVITY_AUDIT, "活动管理:提交审批", true), ACTIVITY_REFUSE(
		        Permission.ACTIVITY_REFUSE, "活动管理:拒绝", true), ACTIVITY_READY_LIST(Permission.ACTIVITY_READY_LIST, "活动管理:待上架", true), ACTIVITY_LIST(Permission.ACTIVITY_LIST, "活动管理:上架", true), ACTIVITY_DELIST(Permission.ACTIVITY_DELIST, "活动管理:下架", true), ACTIVITY_DISCARD(Permission.ACTIVITY_DISCARD, "活动管理:作废", true), AUCTION_VIEW(Permission.AUCTION_VIEW, "竞拍用户管理", true), ORDER_VIEW(Permission.ORDER_VIEW, "订单管理", true), ORDER_EXPORT(Permission.ORDER_EXPORT, "订单管理:导出订单", true), ORDER_IMPORT(Permission.ORDER_IMPORT, "订单管理:批量导入发货", true), ORDER_CANCEL(Permission.ORDER_CANCEL, "订单管理:取消", true), ORDER_DEAL(Permission.ORDER_DEAL, "订单管理:处理", true), ORDER_MODIFYEXPRESS(Permission.ORDER_MODIFYEXPRESS, "订单管理:修改物流", true), ORDER_CONFIRMSUCCESS(Permission.ORDER_CONFIRMSUCCESS, "订单管理:确认收货", true), ORDER_SEND(
		        Permission.ORDER_SEND, "订单管理:发货", true), ORDER_REFUND(Permission.ORDER_REFUND, "订单管理:退货", true), ORDER_EXCHANGE(Permission.ORDER_EXCHANGE, "订单管理:换货", true), ORDER_CONFIRMREFUND(Permission.ORDER_CONFIRMREFUND, "订单管理:确认退货", true), ORDER_CONFIRMEXCHANGE(Permission.ORDER_CONFIRMEXCHANGE, "订单管理:确认换货", true), SKU_VIEW(Permission.SKU_VIEW, "库存管理", true), PRODUCT_VIEW(Permission.PRODUCT_VIEW, "商品管理", true), PRODUCT_ADD(Permission.PRODUCT_ADD, "商品管理:添加", true), PRODUCT_EDIT(Permission.PRODUCT_EDIT, "商品管理:编辑", true), PRODUCT_DISCARD(Permission.PRODUCT_DISCARD, "商品管理:作废", true), PRODUCT_SUBMITAUDIT(Permission.PRODUCT_SUBMITAUDIT, "商品管理:提交审批", true), PRODUCT_AUDITREFUSE(Permission.PRODUCT_AUDITREFUSE, "商品管理:审批拒绝", true), PRODUCT_AUDITOK(Permission.PRODUCT_AUDITOK, "商品管理:审批通过", true), PRODUCT_DELIST(
		        Permission.PRODUCT_DELIST, "商品管理:下架", true), PRODUCT_LIST(Permission.PRODUCT_LIST, "商品管理:上架", true), CATALOG_VIEW(Permission.CATALOG_VIEW, "分类管理", true), SUPPLIER_VIEW(Permission.SUPPLIER_VIEW, "供应商管理", true), BRAND_VIEW(Permission.BRAND_VIEW, "品牌管理", true), ROLE_VIEW(Permission.ROLE_VIEW, "角色管理", true), ADV_VIEW(Permission.ADV_VIEW, "广告管理", true), SETT_VIEW(Permission.SETT_VIEW, "网站设置", true),

		USERLEVEL_VIEW(Permission.USERLEVEL_VIEW, "会员等级管理", true), USERLEVEL_CREATE(Permission.USERLEVEL_CREATE, "会员等级-新增", true), USERLEVEL_DELETE(Permission.USERLEVEL_DELETE, "会员等级-删除", true), USERLEVEL_EDIT(Permission.USERLEVEL_EDIT, "会员等级-编辑", true),

		CENTBUDGET_VIEW(Permission.CENTBUDGET_VIEW, "积分预算", true), CENTBUDGET_ADD(Permission.CENTBUDGET_ADD, "积分预算:添加", true), CENTBUDGET_EDIT(Permission.CENTBUDGET_EDIT, "积分预算:编辑", true), CENTBUDGET_DELETE(Permission.CENTBUDGET_DELETE, "积分预算:删除", true), CENTS_VIEW(Permission.CENTS_VIEW, "积分管理", true), CENTS_ADDAPPLY(Permission.CENTS_ADDAPPLY, "手工增加积分申请", true), CENTS_SUBAPPLY(Permission.CENTS_SUBAPPLY, "手工减少积分申请", true),

		CENTRULE_VIEW(Permission.CENTRULE_VIEW, "积分规则", true), CENTRULE_CREATE(Permission.CENTRULE_CREATE, "积分规则-增加", true), CENTRULE_DELETE(Permission.CENTRULE_DELETE, "积分规则-删除", true), CENTRULE_EDIT(Permission.CENTRULE_EDIT, "积分规则-编辑", true),

		CENTIMPORT_VIEW(Permission.CENTIMPORT_VIEW, "积分申请单", true), CENTIMPORT_IMPORT(
		// Permission.CENTIMPORT_IMPORT, "积分导入:积分导入", true), CENTIMPORT_EDIT(
		        Permission.CENTIMPORT_EDIT, "积分申请单:编辑", true), CENTIMPORT_SUBMITAUDIT(Permission.CENTIMPORT_SUBMITAUDIT, "积分申请单:提交审批", true), CENTIMPORT_AUDIT(Permission.CENTIMPORT_AUDIT, "积分申请单:审批积分", true), CENTIMPORT_DELETE(Permission.CENTIMPORT_DELETE, "积分申请单:删除", true), CENTPLAN_VIEW(Permission.CENTPLAN_VIEW, "积分发放计划", true), CENTPLAN_ADD(Permission.CENTPLAN_ADD, "积分发放计划:添加", true), CENTPLAN_EDIT(Permission.CENTPLAN_EDIT, "积分发放计划:编辑", true), CENTPLAN_PLANRULE(Permission.CENTPLAN_PLANRULE, "积分发放计划:关联积分规则", true), CENTCONSUME_VIEW(Permission.CENTCONSUME_VIEW, "积分消耗", true), ADMINMGR_VIEW(Permission.ADMINMGR_VIEW, "管理员管理", true), EXPRESS_VIEW(Permission.EXPRESS_VIEW, "快递公司字典", true), PLATFORM_VIEW(Permission.PLATFORM_VIEW, "系统平台字典", true), DEPARTMENT_VIEW(Permission.DEPARTMENT_VIEW,
		        "部门字典", true), CENTCONSUMEDICT_VIEW(Permission.CENTCONSUMEDICT_VIEW, "积分消耗类型字典", true), SYSTEMSETTINGS_VIEW(Permission.SYSTEMSETTINGSDICT_VIEW, "系统常量设置", true),

		PRODSTOCK_VIEW(Permission.PRODSTOCK_VIEW, "出入库管理", true), PRODSTOCK_IN(Permission.PRODSTOCK_IN, "出入库管理:入库", true), PRODSTOCK_OUT(Permission.PRODSTOCK_OUT, "出入库管理:出库", true), PRODSTOCK_EDIT(Permission.PRODSTOCK_EDIT, "出入库管理:编辑", true), PRODSTOCK_AUDIT(Permission.PRODSTOCK_AUDIT, "出入库管理:审批", true),

		// 虚拟商品卡密管理
		VIRTUALPRODUCT_VIEW(Permission.VIRTUALPRODUCT_VIEW, "虚拟商品卡密管理", true), VIRTUALPRODUCT_ADD(Permission.VIRTUALPRODUCT_ADD, "虚拟商品卡密管理:增加", true), VIRTUALPRODUCT_EDIT(Permission.VIRTUALPRODUCT_EDIT, "虚拟商品卡密管理:修改", true), VIRTUALPRODUCT_DELETE(Permission.VIRTUALPRODUCT_DELETE, "虚拟商品卡密管理:删除", true), VIRTUALPRODUCT_IMPORT(Permission.VIRTUALPRODUCT_IMPORT, "虚拟商品卡密管理:导入", true),

		// 退换货管理
		PROD_RETURN_VIEW(Permission.PROD_RETURN_VIEW, "退换货管理", true);

		Permissions(final String permission, final String label, final boolean assignable) {
			this.permission = permission;
			this.label = label;
			this.assignable = assignable;
            this.hasPermission=false;
		}

		private final String permission;
		private final String label;
		private final String name=this.name();
		private boolean hasPermission;

        /**
		 * true 可以分配 false 保留
		 */
		private final boolean assignable;// 能否分配

		public String getLabel() {
			return label;
		}

		public String getPermission() {
			return permission;
		}

		public boolean isAssignable() {
			return assignable;
		}

        public boolean isHasPermission() {
            return hasPermission;
        }
        public void setHasPermission(boolean hasPermission) {
             this.hasPermission=hasPermission;
        }

        public String getName() {
            return name;
        }
    }

	public static Map<String, Permissions> convertAllPermissionsToMap() {
		return convertPermissionsToMap(null);
	}

	public static Map<String, Permissions> convertAssignablePermissionsToMap() {
		return convertPermissionsToMap(Boolean.TRUE);
	}

	public static Map<String, Permissions> convertDisAssignablePermissionsToMap() {
		return convertPermissionsToMap(Boolean.FALSE);
	}

	/***
	 * 将权限转换成map
	 * 
	 * @param assignable
	 *            是否可以分配
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private static Map<String, Permissions> convertPermissionsToMap(Boolean assignable) {
		// Map<String, Permissions> map = Maps.newHashMap();
		Map<String, Permissions> map = (Map<String, Permissions>) new ListOrderedMap();
		for (Permissions per : Permissions.values()) {

			if (assignable != null) {
				if (assignable == per.isAssignable()) {
					map.put(per.getPermission(), per);
				}
			} else {
				map.put(per.getPermission(), per);
			}
		}
		return map;
	}

    /**
     * 所有权限按模块分组
     * @return
     */
    public static Map<String, List> convertPermissionsToMapJson() {
        final Map<String, List> viewMap = Maps.newHashMap();
        List group = null;

        String permissionKey  = null;//比如express:list:view中的express
		for (Permissions per : Permissions.values()) {
            permissionKey = per.getPermission().split(":")[0];

            if (viewMap.containsKey(permissionKey)){
                group = viewMap.get(permissionKey);
            }else{
                group = new ArrayList();
            }

            group.add(per);
            viewMap.put(permissionKey,group);
		}
		return viewMap;
	}

    /**
     * 所有权限按模块分组
     * 并对角色的权限增加是否显示属性
     * @return
     */
    public static Map<String, List> convertPermissionsToMapJsonAndCheckRolePermissions(List<String> hasPermissions) {
        if (Collections3.isEmpty(hasPermissions)){
            return convertPermissionsToMapJson();
        }

        final Map<String, List> viewMap = Maps.newHashMap();
        List group = null;

        String permissionKey  = null;//比如express:list:view中的express
		//Map<String, Object> map = null;
		for (Permissions per : Permissions.values()) {
            permissionKey = per.getPermission().split(":")[0];

            if (viewMap.containsKey(permissionKey)){
                group = viewMap.get(permissionKey);
            }else{
                group = new ArrayList();
            }

            if (hasPermissions.contains(per.getPermission())){
                per.setHasPermission(true);
            }
            group.add(per);
            viewMap.put(permissionKey,group);
		}
		return viewMap;
	}


    /**
     * 分组的键值形式
     * @param reMap
     * @return
     */
    public static List convertToKeyValue(Map<String,List> reMap){
        final List viewList = new ArrayList(reMap.size());
        for (Map.Entry<String, List> obj :reMap.entrySet()){
            viewList.add(obj);
        }
        return viewList;
    }


    /**
     * 将最高权限＊提前
     * @param reMap
     * @return
     */
    public static LinkedHashMap<String,List> convertHeighestPerToFirst(Map<String,List> reMap){
        LinkedHashMap<String,List> sortMap = Maps.newLinkedHashMap();
        sortMap.put("*",reMap.get("*"));
        reMap.remove("*");
        sortMap.putAll(reMap);

        return sortMap;
    }

    /**
     * [{
     key:string 名称,
     value:[{
     assignable:true,//请写明字段含义
     label:'中文名',
     name:string,
     permission:true,
     hasPermission:true
     },...]
     },...]
     * @return
     */
    public static List getGroupKeyValuePermissions(){
        return Permission.convertToKeyValue(Permission.convertHeighestPerToFirst(Permission.convertPermissionsToMapJson()));
    }

    /**
     * 返回所有权限，并对给定的权限加上hasPermission＝true
     * @param hasPermissions
     * @return
     */
    public static List getHasPermissionGroupKeyValuePermissions(List<String> hasPermissions){
        return Permission.convertToKeyValue(Permission.convertHeighestPerToFirst(Permission.convertPermissionsToMapJsonAndCheckRolePermissions(hasPermissions)));
    }
}