package com.rocoinfo.rocomall.entity.activity;

import java.util.Date;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Sku;

/**
 * 活动相关商品
 * 
 * @author wx
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivitySku extends IdEntity{

	private static final long serialVersionUID = 8445834140247771019L;
	
	@JsonIgnore
	private Activity activity;
	
	private Sku sku;
	
	private Integer cent;
	
	/**
	 * 中奖参数,必须是参与积分的整数倍
	 */
	private Integer hitParameter;
	
	/**
	 * 总奖品数量
	 */
	private Integer prizeNum;
	
	/**
	 * 已中奖品数
	 */
	private Integer hitNum;
	
    private Integer count;
    
	private Date presaleDeliveryTime;
	
	//是否显示预售时间 true=>不显示预售时间， false=>显示预售时间
	private Boolean hidePresaleDeliveryTime;
	
	//抽奖时几等奖排序
	@Transient
	private Integer sortOrder;
	
	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	public Sku getSku() {
		return sku;
	}

	public void setSku(Sku sku) {
		this.sku = sku;
	}

	public Date getPresaleDeliveryTime() {
		return presaleDeliveryTime;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public void setPresaleDeliveryTime(Date presaleDeliveryTime) {
		this.presaleDeliveryTime = presaleDeliveryTime;
	}
	

	public Boolean getHidePresaleDeliveryTime() {
		return hidePresaleDeliveryTime;
	}

	public void setHidePresaleDeliveryTime(Boolean hidePresaleDeliveryTime) {
		this.hidePresaleDeliveryTime = hidePresaleDeliveryTime;
	}

	public Integer getHitParameter() {
		return hitParameter;
	}

	public void setHitParameter(Integer hitParameter) {
		this.hitParameter = hitParameter;
	}

	public Integer getPrizeNum() {
		return prizeNum;
	}

	public void setPrizeNum(Integer prizeNum) {
		this.prizeNum = prizeNum;
	}

	public Integer getHitNum() {
		return hitNum;
	}

	public void setHitNum(Integer hitNum) {
		this.hitNum = hitNum;
	}

	public Integer getCount(){
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}

	public Integer getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}
	
	
}