package com.rocoinfo.rocomall.entity.cent;


import com.rocoinfo.rocomall.utils.ExcelTitle;

public class CentBudgetReport {

	private final int N = 100;
	//id
	private int id;
	//年份
	private String year;
	//部门名称
	private String department;
	//部门ID
	private String department_id;
	//预算项
	private String subject;
	//预算项
	private String subject_code;
	//总积分
	private Integer totalCent;
	//总金额
	private Double totalCentAm;
	//已发放积分
	private Integer alreadyGrantCent;
	//已发放金额
	private Double alreadyGrantCentAm;
	//未发放积分
	private Integer notAlreadyGrantCent;
	//未发放金额
	private Double notAlreadyGrantCentAm;
	//已失效积分
	private Integer alreadyInvalidCent;
	//已失效金额
	private Double alreadyInvalidCentAm;
	//已使用积分
	private Integer alreadyUsedCent;
	//已使用金额
	private Double alreadyUsedCentAm;
	
	@ExcelTitle(title = "年份", order = 1)
	public String getYear() {
		return year;
	}
	public void setYear(String year) {
		this.year = year;
	}
	
	@ExcelTitle(title = "部门名称", order = 2)
	public String getDepartment() {
		return department;
	}
	public void setDepartment(String department) {
		this.department = department;
	}
	
	public String getDepartment_id() {
		return department_id;
	}
	public void setDepartment_id(String department_id) {
		this.department_id = department_id;
	}
	
	@ExcelTitle(title = "预算项", order = 3)
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	
	@ExcelTitle(title = "总积分", order = 4)
	public Integer getTotalCent() {
		return totalCent;
	}
	public void setTotalCent(Integer totalCent) {
		this.totalCent = totalCent;
		totalCentAm = Double.valueOf(totalCent)/N;
	}
	
	@ExcelTitle(title = "总金额", order = 5)
	public Double getTotalCentAm() {
		return totalCentAm;
	}
	public void setTotalCentAm(Double totalCentAm) {
		this.totalCentAm = totalCentAm;
	}
	
	@ExcelTitle(title = "已发放积分", order = 6)
	public Integer getAlreadyGrantCent() {
		return alreadyGrantCent;
	}
	public void setAlreadyGrantCent(Integer alreadyGrantCent) {
		this.alreadyGrantCent = alreadyGrantCent;
		alreadyGrantCentAm = Double.valueOf(alreadyGrantCent)/N;
	}
	
	@ExcelTitle(title = "已发放积分金额", order = 7)
	public Double getAlreadyGrantCentAm() {
		return alreadyGrantCentAm;
	}
	public void setAlreadyGrantCentAm(Double alreadyGrantCentAm) {
		this.alreadyGrantCentAm = alreadyGrantCentAm;
	}
	
	
	@ExcelTitle(title = "未发放积分", order = 8)
	public Integer getNotAlreadyGrantCent() {
		return notAlreadyGrantCent;
	}
	public void setNotAlreadyGrantCent(Integer notAlreadyGrantCent) {
		this.notAlreadyGrantCent = notAlreadyGrantCent;
		notAlreadyGrantCentAm = Double.valueOf(notAlreadyGrantCent)/N;
	}
	
	@ExcelTitle(title = "未发放积分金额", order = 9)
	public Double getNotAlreadyGrantCentAm() {
		return notAlreadyGrantCentAm;
	}
	public void setNotAlreadyGrantCentAm(Double notAlreadyGrantCentAm) {
		this.notAlreadyGrantCentAm = notAlreadyGrantCentAm;
	}
	
	@ExcelTitle(title = "已失效积分", order = 10)
	public Integer getAlreadyInvalidCent() {
		return alreadyInvalidCent;
	}
	public void setAlreadyInvalidCent(Integer alreadyInvalidCent) {
		alreadyInvalidCentAm = Double.valueOf(alreadyInvalidCent)/N;
		this.alreadyInvalidCent = alreadyInvalidCent;
	}
	
	@ExcelTitle(title = "已失效积分金额", order = 11)
	public Double getAlreadyInvalidCentAm() {
		return alreadyInvalidCentAm;
	}
	public void setAlreadyInvalidCentAm(Double alreadyInvalidCentAm) {
		this.alreadyInvalidCentAm = alreadyInvalidCentAm;
	}
	
	@ExcelTitle(title = "已使用积分", order = 12)
	public Integer getAlreadyUsedCent() {
		return alreadyUsedCent;
	}
	public void setAlreadyUsedCent(Integer alreadyUsedCent) {
		this.alreadyUsedCent = alreadyUsedCent;
		alreadyUsedCentAm = Double.valueOf(alreadyUsedCent)/N;
	}
	
	@ExcelTitle(title = "已使用积分金额", order = 13)
	public Double getAlreadyUsedCentAm() {
		return alreadyUsedCentAm;
	}
	public void setAlreadyUsedCentAm(Double alreadyUsedCentAm) {
		this.alreadyUsedCentAm = alreadyUsedCentAm;
	}
	
	
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	
	
	public String getSubject_code() {
		return subject_code;
	}
	public void setSubject_code(String subject_code) {
		this.subject_code = subject_code;
	}
	
	
	
}
