package com.rocoinfo.rocomall.entity.order;

import java.util.Date;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;

/**
 * <dl>
 * <dd>描述:入库单:商品入库的entity</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/11/12 17:30</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
public class InstoreOrder extends IdEntity {

	private static final long serialVersionUID = 2886269314275183469L;

	/**
	 * 入库类型:采购入库 退货入库
	 */
	private InstoreType inType;

	/**
	 * 入库单编号
	 */
	private String code;

	/**
	 * 入库仓库
	 */
	private DictWarehouse warehouse;

	/**
	 * 入库商品的Sku
	 */
	private Sku sku;

	/**
	 * 入库数量
	 */
	private Integer quantity;

	/**
	 * 入库操作人
	 */
	private AdminUser operator;

	/**
	 * 收货状态
	 */
	private ReceiveStatus receiveState;

	/**
	 * 收货日期
	 */
	private Date receiveDateTime;

	/**
	 * 备注
	 */
	private String note;

	/**
	 * 入库单创建日期
	 */
	private Date createTime;

	/**
	 * 退货入库 对应的子订单号
	 */
	private String orderCode;

	/**
	 * 退货入库 对应的退货明细记录Id
	 */
	private Long refundDetailId;

	public enum InstoreType {
		PURCHASE("采购入库"), REFUND("退货入库");
		private String label;

		InstoreType(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	public enum ReceiveStatus {
		FINISHED("已收货"), UNFINISHED("未收货");
		private String label;

		ReceiveStatus(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public InstoreType getInType() {
		return inType;
	}

	public void setInType(InstoreType inType) {
		this.inType = inType;
	}

	public DictWarehouse getWarehouse() {
		return warehouse;
	}

	public void setWarehouse(DictWarehouse warehouse) {
		this.warehouse = warehouse;
	}

	public Sku getSku() {
		return sku;
	}

	public void setSku(Sku sku) {
		this.sku = sku;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public AdminUser getOperator() {
		return operator;
	}

	public void setOperator(AdminUser operator) {
		this.operator = operator;
	}

	public ReceiveStatus getReceiveState() {
		return receiveState;
	}

	public void setReceiveState(ReceiveStatus receiveState) {
		this.receiveState = receiveState;
	}

	public Date getReceiveDateTime() {
		return receiveDateTime;
	}

	public void setReceiveDateTime(Date receiveDateTime) {
		this.receiveDateTime = receiveDateTime;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public Long getRefundDetailId() {
		return refundDetailId;
	}

	public void setRefundDetailId(Long refundDetailId) {
		this.refundDetailId = refundDetailId;
	}
}
