package com.rocoinfo.rocomall.entity.order;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.annotation.Transient;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.User;

/**
 * <dl>
 * <dd>描述: 订单实体bean</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/17 20:38</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 * 
 * @author huyt
 * @author zhangmin
 */
public class Order extends IdEntity {
	private static final long serialVersionUID = -8411839450593890824L;

	/**
	 * 订单编号
	 */
	private String orderCode;

	/**
	 * 用户信息
	 */
	private User user;

	/**
	 * 购买此订单时用户的等级名称，用来显示
	 */
	private String userLevelName;

	/**
	 * 商家发货信息
	 */
	private DeliveryTimePreference deliveryTimePreference;

	/**
	 * 发票类型
	 */
	private InvoiceType invoiceType;

	/**
	 * 发票抬头 :例如公司名称 *
	 */
	private String invoiceTitle;

	/**
	 * 支付类型
	 */
	private PaymentType paymentType;

	/**
	 * 现金支付类型
	 */
	private CashPayType cashPayType;

	/**
	 * 运费
	 */
	private Double deliverFee;

	/**
	 * 订单现金部分
	 */
	private Double cashAmt;

	/**
	 * 订单积分部分
	 */
	private Integer cent;

	//订单校验状态
	private CheckState checkState;

	//是否生成了配送单
	private Boolean distributed;

	/**
	 * 是否锁定,只有异常订单才能锁定 <br/>
	 * (1)如果从来没有点击过“锁定”按钮的订单， 由 "未锁定" =>“已锁定”，释放占用库存 <br/>
	 * (2)锁定状态：由“已锁定” =>"未锁定",占用库存不变 <br/>
	 * (3)如果异常订单是“未锁定”状态，并且审核通过，则重新占用上 “占用库存”，如果此时没有了库存则提示“库存不足，不能通过！"。
	 */
	private Boolean locked;

	/**
	 * 是否点击过锁定按钮,只要点击过一次锁定操作，则就是点击过锁定按钮，点击过“锁定”按钮，表示的意思就是“是否释放过占用库存”
	 */
	private Boolean clickedLockBtn;

	/**
	 * 现金支付时第三方系统的交易号
	 */
	private String tradeNo;

	/**
	 * 第三方现金支付系统交易状态
	 */
	private String tradeState;

	/**
	 * 是否现金支付
	 */
	private Boolean cashPayed;
	/**
	 * 是否积分支付
	 */
	private Boolean centPayed;
	/**
	 * 订单支付完成时间
	 */
	private Date payedTime;

	private String note;

	/** 创建时间 */
	private Date createTime;

	/***
	 * 订单项
	 */
	@Transient
	private List<OrderItem> items;

	//订单收货地址
	@Transient
	private OrderDelivery delivery;

	public Order() {
	}

	public Order(Long id) {
		this.id = id;
	}

	/**
	 * 支付类型
	 */
	public static enum PaymentType {
		CASH("全现金"), CENT("全积分"), CASH_AND_CENT("积分+现金");

		private String label;

		PaymentType(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	/**
	 * 现金支付类型
	 */
	public enum CashPayType {
		UNIONPAY("银联"), ALIPAY("支付宝");

		private String label;

		private CashPayType(final String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	/**
	 * 发票类型
	 */
	public static enum InvoiceType {
		NONE("不开发票"), PERSONAL("个人"), COMPANY("单位");
		private String label;

		InvoiceType(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	public static enum CheckState {
		EXCEPTION("异常"), NORMAL("正常");
		private String label;

		CheckState(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	/**
	 * 商家发货时段类型
	 */
	public enum DeliveryTimePreference {
		WEEKDAYS("只工作日送货"), WEEKENDS("只双休日、假日送货 "), ANYDAY("工作日、双休日或假日均可送货");

		private String label;

		DeliveryTimePreference(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public DeliveryTimePreference getDeliveryTimePreference() {
		return deliveryTimePreference;
	}

	public void setDeliveryTimePreference(DeliveryTimePreference deliveryTimePreference) {
		this.deliveryTimePreference = deliveryTimePreference;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public List<OrderItem> getItems() {
		return items;
	}

	public void setItems(List<OrderItem> items) {
		this.items = items;
	}

	public void addItem(OrderItem orderItem) {
		if (orderItem != null) {
			if (items == null) {
				items = Lists.newArrayList();
			}
			items.add(orderItem);
		}
	}

	/**
	 * 计算总共为您结算 xxx 积分
	 */
	public int getTotalSavedCent() {
		int totalSaved = 0;
		if (CollectionUtils.isNotEmpty(items)) {
			for (OrderItem orderItem : items) {
				int itemSaved = (orderItem.getOriginalCent() - orderItem.getCent()) * orderItem.getQuantity();
				totalSaved += itemSaved;
			}
		}
		return totalSaved;
	}

	public InvoiceType getInvoiceType() {
		return invoiceType;
	}

	public void setInvoiceType(InvoiceType invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getInvoiceTitle() {
		return invoiceTitle;
	}

	public void setInvoiceTitle(String invoiceTitle) {
		this.invoiceTitle = invoiceTitle;
	}

	public PaymentType getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(PaymentType paymentType) {
		this.paymentType = paymentType;
	}

	public CashPayType getCashPayType() {
		return cashPayType;
	}

	public void setCashPayType(CashPayType cashPayType) {
		this.cashPayType = cashPayType;
	}

	public Double getDeliverFee() {
		return deliverFee;
	}

	public void setDeliverFee(Double deliverFee) {
		this.deliverFee = deliverFee;
	}

	public Double getCashAmt() {
		return cashAmt;
	}

	public void setCashAmt(Double cashAmt) {
		this.cashAmt = cashAmt;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public String getUserLevelName() {
		return userLevelName;
	}

	public void setUserLevelName(String userLevelName) {
		this.userLevelName = userLevelName;
	}

	public OrderDelivery getDelivery() {
		return delivery;
	}

	public void setDelivery(OrderDelivery delivery) {
		this.delivery = delivery;
	}

	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public String getTradeState() {
		return tradeState;
	}

	public void setTradeState(String tradeState) {
		this.tradeState = tradeState;
	}

	public Boolean getCashPayed() {
		return cashPayed;
	}

	public void setCashPayed(Boolean cashPayed) {
		this.cashPayed = cashPayed;
	}

	public Boolean getCentPayed() {
		return centPayed;
	}

	public void setCentPayed(Boolean centPayed) {
		this.centPayed = centPayed;
	}

	public Date getPayedTime() {
		return payedTime;
	}

	public void setPayedTime(Date payedTime) {
		this.payedTime = payedTime;
	}

	public CheckState getCheckState() {
		return checkState;
	}

	public void setCheckState(CheckState checkState) {
		this.checkState = checkState;
	}

	public Boolean getDistributed() {
		return distributed;
	}

	public void setDistributed(Boolean distributed) {
		this.distributed = distributed;
	}

	public Boolean getLocked() {
		return locked;
	}

	public void setLocked(Boolean locked) {
		this.locked = locked;
	}

	public Boolean getClickedLockBtn() {
		return clickedLockBtn;
	}

	public void setClickedLockBtn(Boolean clickedLockBtn) {
		this.clickedLockBtn = clickedLockBtn;
	}
}
