package com.rocoinfo.rocomall.entity.workorder;

import java.util.Date;
import java.util.List;

import org.springframework.data.annotation.Transient;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.order.Order;

/**
 * <dl>
 * <dd>描述:客服工单</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月18日 上午10:34:59</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
public class WorkOrder extends IdEntity {

	private static final long serialVersionUID = 3248596776953382647L;
	/**
	 * 工单号,系统生成
	 */
	private String code;
	/**
	 * 工单类别: 咨询、投诉、退货
	 */
	private Type type;

	/**
	 * 退货总订单
	 */
	private Order order;

	/**
	 * 状态（未结案/已结案) <br/>
	 * 说明：如果是退货工单，只有退货入库单都 “确认收货” 后，才显示“结案”按钮
	 */
	private Boolean state;

	/**
	 */
	private DictExpress express;

	/**
	 * 物流单号
	 */
	private String transportNo;

	/**
	 * 工单创建时间
	 */
	private Date createTime;

	/**
	 * 结案操作人
	 */
	private AdminUser operator;
	/**
	 * 结案操作时间
	 */
	private Date operatorDatetime;

	/**
	 * 退货商品明细
	 */
	private List<WorkOrderRefundDetail> workOrderRefundDetails;

	/**
	 * 是否允许做"结案" 操作
	 */
	@Transient
	private Boolean closeAllowed;

	public static enum Type {
		CONSULT("咨询"), COMPLAINT("投诉"), REFUND("退货");
		private String label;

		Type(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	/**
	 * 工单号,系统生成
	 */
	public String getCode() {
		return code;
	}

	/**
	 * 工单号,系统生成
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * 工单类别: 咨询、投诉、退货
	 */
	public Type getType() {
		return type;
	}

	/**
	 * 工单类别: 咨询、投诉、退货
	 */
	public void setType(Type type) {
		this.type = type;
	}

	/**
	 * order_code(总订单编号,只有退货工单才有订单号（unique）)
	 */
	public Order getOrder() {
		return order;
	}

	/**
	 * order_code(总订单编号,只有退货工单才有订单号（unique）)
	 */
	public void setOrder(Order order) {
		this.order = order;
	}

	/**
	 * 状态（未结案/已结案)
	 */
	public Boolean getState() {
		return state;
	}

	/**
	 * 状态（未结案/已结案)
	 */
	public void setState(Boolean state) {
		this.state = state;
	}

	public Boolean getCloseAllowed() {
		return closeAllowed;
	}

	public void setCloseAllowed(Boolean closeAllowed) {
		this.closeAllowed = closeAllowed;
	}

	/**
	 * express_id(快递Id)
	 */
	public DictExpress getExpress() {
		return express;
	}

	/**
	 * express_id(快递Id)
	 */
	public void setExpress(DictExpress express) {
		this.express = express;
	}

	/**
	 * 物流单号(transport_no)
	 */
	public String getTransportNo() {
		return transportNo;
	}

	/**
	 * 物流单号(transport_no)
	 */
	public void setTransportNo(String transportNo) {
		this.transportNo = transportNo;
	}

	/**
	 * create_time(工单创建时间)
	 */
	public Date getCreateTime() {
		return createTime;
	}

	/**
	 * create_time(工单创建时间)
	 */
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 操作人(数据库字段：operatorId)(结案人)
	 */
	public AdminUser getOperator() {
		return operator;
	}

	/**
	 * 操作人(数据库字段：operatorId)(结案人)
	 */
	public void setOperator(AdminUser operator) {
		this.operator = operator;
	}

	/**
	 * 操作时间(结案的时间)
	 */
	public Date getOperatorDatetime() {
		return operatorDatetime;
	}

	/**
	 * 操作时间(结案的时间)
	 */
	public void setOperatorDatetime(Date operatorDatetime) {
		this.operatorDatetime = operatorDatetime;
	}

	public List<WorkOrderRefundDetail> getWorkOrderRefundDetails() {
		return workOrderRefundDetails;
	}

	public void setWorkOrderRefundDetails(List<WorkOrderRefundDetail> workOrderRefundDetails) {
		this.workOrderRefundDetails = workOrderRefundDetails;
	}
}
