package com.rocoinfo.rocomall.entity.wx;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.MenuEventType;

/***
 * 后台系统自定义的菜单，需要保存到数据库中
 */
public class Menu extends IdEntity {

	private static final long serialVersionUID = -4529012529935060749L;

	public static final String MENU_ACT_SEPERATOR = "_";

	/**
	 * 订单查询
	 */
	public static final String ACT_ORDER_QUERY = "orderQuery";

	/**
	 * 个人信息
	 */
	public static final String ACT_PERSONAL_INFO = "myInfo";

	/**
	 * 物流查询
	 */
	public static final String ACT_LOGISTICS_INQUIRY = "logisticsInquiry";

	/**
	 * 菜单名称
	 */
	private String menuName = StringUtils.EMPTY;

	/**
	 * 菜单显示顺序
	 */
	private Integer seq;

	/***
	 * 父菜单Id
	 */
	private Long pid;

	/**
	 * 菜单事件处理类型
	 */
	private MenuEventType menuType;

	/***
	 * 菜单的动作：用来区别到底是什么菜单 例如act可以是{myorder,myaccount}
	 */
	private String act;

	/**
	 * 菜单是否必须绑定后才能访问
	 */
	private Boolean boundAccess;

	/**
	 * view类型时:用户点击菜单可打开链接
	 */
	private String linkUrl = StringUtils.EMPTY;

	private List<Menu> childMenuList;// 子类菜单

	public void addChildMenu(Menu child) {
		if (child != null) {
			if (this.childMenuList == null) {
				this.childMenuList = new ArrayList<Menu>();
			}
			childMenuList.add(child);
		}
	}

	public List<Menu> getChildMenuList() {
		return childMenuList;
	}

	public void setChildMenuList(List<Menu> childMenuList) {
		this.childMenuList = childMenuList;
	}

	public String getMenuName() {
		return menuName;
	}

	public void setMenuName(String menuName) {
		this.menuName = menuName;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public Boolean getBoundAccess() {
		return boundAccess;
	}

	public void setBoundAccess(Boolean boundAccess) {
		this.boundAccess = boundAccess;
	}

	public Integer getSeq() {
		return seq;
	}

	public void setSeq(Integer seq) {
		this.seq = seq;
	}

	public MenuEventType getMenuType() {
		return menuType;
	}

	public void setMenuType(MenuEventType menuType) {
		this.menuType = menuType;
	}

	public String getLinkUrl() {
		return linkUrl;
	}

	public void setLinkUrl(String linkUrl) {
		this.linkUrl = linkUrl;
	}

	public String getAct() {
		return act;
	}

	public void setAct(String act) {
		this.act = act;
	}
}
