package com.rocoinfo.rocomall.entity.wx;

import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.WXMsgType;
import com.rocoinfo.rocomall.utils.CodeGenerator;

/***
 * 消息持久化Po
 * 
 * @author zhangmin
 */
public class MsgEntity extends IdEntity {

	private static final long serialVersionUID = 307565296322061661L;

	/**
	 * 未绑定时，提示绑定消息
	 */
	public static final String BIND_MSG = "bindMessage";

	/**
	 * 订单查询 =>尚无订单信息
	 */
	public static final String WITHOUT_ORDER_MSG = "withoutOrderMsg";

	/**
	 * 物流查询（取最近的1单） => 无物流信息
	 */
	public static final String WITHOUT_LOGISTIC_MSG = "withoutLogisticMsg";

	/**
	 * 物流查询（取最近的1单） => 正在处理中
	 */
	public static final String PROCESSING_LOGISTIC_MSG = "processingLogisticMsg";

	/**
	 * 消息类型 TEXT/IMAGE/MUSIC
	 */
	private WXMsgType msgType;

	/**
	 * 消息的编号 由微站生成
	 */
	private String messageId;

	/**
	 * 此消息是回复哪个消息
	 */
	private String replayMessageId;

	/**
	 * 消息的创建时间(单位：秒)
	 */
	private Integer createTime;

	/***
	 * 接受到的消息的id,由微信生成
	 */
	private Long msgId;

	/**
	 * 文本消息/图文消息内容
	 */
	private String content;

	/**
	 * 图文消息的图文封面（图片网址URL）,只有第一条图文消息做为大封面，其他的则显示缩略图， 如果是图文消息则存相对路径 例如：image/a.jpg
	 * 
	 * 接收的图片消息的图片链接
	 */
	private String picUrl;

	/**
	 * 图片消息媒体id/语音消息媒体id/视频消息媒体id
	 */
	private String mediaId;

	/**
	 * 语音消息格式
	 */
	private String format;

	/**
	 * 视频消息缩略图的媒体id，可以调用多媒体文件下载接口拉取数据
	 */
	private String thumbMediaId;

	/**
	 * [链接消息/视频消息/音乐/图文]标题
	 */
	private String title;

	/***
	 * [链接消息/视频消息/音乐/图文消息摘要]消息描述
	 */
	private String description;

	/***
	 * 链接消息的链接/图文消息点击后跳转的链接
	 */
	private String url;

	/**
	 * 事件类型 subscribe/unsubscribe/LOCATION/CLICK
	 */
	private String eventType;

	/***
	 * 事件KEY值,与自定义菜单接口中KEY值对应
	 */
	private String eventKey;

	/**
	 * 图文消息的作者
	 */
	private String author;

	/**
	 * 图文消息 阅读原文跳转的URL
	 */
	private String sourceUrl;

	/**
	 * 音乐链接
	 */
	private String musicURL;

	/**
	 * 高质量音乐链接，WIFI环境优先使用该链接播放音乐
	 */
	private String hqMusicUrl;

	/**
	 * 地理位置纬度
	 */
	private BigDecimal locationX;

	/**
	 * 地理位置经度
	 */
	private BigDecimal locationY;

	/***
	 * 地理位置精度
	 */
	private BigDecimal precision;

	/**
	 * 地图缩放大小
	 */
	private BigDecimal scale;

	/**
	 * 地理位置信息
	 */
	private String label;

	//非PO属性   消息发送者
	private String sender;

	private static MsgEntity createMsgEntityInstance() {
		MsgEntity entity = new MsgEntity();
		entity.setCreateTime((int) (System.currentTimeMillis() / 1000));
		entity.setMessageId(CodeGenerator.generateWxMessageId());
		return entity;
	}

	/***
	 * 创建文本消息
	 */
	public static MsgEntity createTextMsgEntity(String msgContent, String replyMsgId) {
		MsgEntity entity = createMsgEntityInstance();
		entity.setContent(msgContent);
		entity.setReplayMessageId(replyMsgId);
		entity.setMsgType(WXMsgType.text);
		return entity;
	}

	/***
	 * 创建图片消息
	 */
	public static MsgEntity createImgMsgEntity(String mediaId) {
		MsgEntity entity = createMsgEntityInstance();
		entity.setMediaId(mediaId);
		entity.setMsgType(WXMsgType.image);
		return entity;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Integer getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Integer createTime) {
		this.createTime = createTime;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 获得单图文信息 摘要
	 * 
	 * @return
	 */
	public String getDigest() {
		String digest = StringUtils.EMPTY;
		if (StringUtils.isNotBlank(description)) {
			digest = description;
		} else {
			digest = content;
		}
		return StringUtils.abbreviate(digest, 50);
	}

	public String getEventKey() {
		return eventKey;
	}

	public void setEventKey(String eventKey) {
		this.eventKey = eventKey;
	}

	public String getEventType() {
		return eventType;
	}

	public void setEventType(String eventType) {
		this.eventType = eventType;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public Long getMsgId() {
		return msgId;
	}

	public void setMsgId(Long msgId) {
		this.msgId = msgId;
	}

	public WXMsgType getMsgType() {
		return msgType;
	}

	public void setMsgType(WXMsgType msgType) {
		this.msgType = msgType;
	}

	public String getMusicURL() {
		return musicURL;
	}

	public void setMusicURL(String musicURL) {
		this.musicURL = musicURL;
	}

	public String getPicUrl() {
		return picUrl;
	}

	public void setPicUrl(String picUrl) {
		this.picUrl = picUrl;
	}

	public String getReplayMessageId() {
		return replayMessageId;
	}

	public BigDecimal getLocationX() {
		return locationX;
	}

	public void setLocationX(BigDecimal locationX) {
		this.locationX = locationX;
	}

	public BigDecimal getLocationY() {
		return locationY;
	}

	public void setLocationY(BigDecimal locationY) {
		this.locationY = locationY;
	}

	public BigDecimal getPrecision() {
		return precision;
	}

	public void setPrecision(BigDecimal precision) {
		this.precision = precision;
	}

	public BigDecimal getScale() {
		return scale;
	}

	public void setScale(BigDecimal scale) {
		this.scale = scale;
	}

	public void setReplayMessageId(String replayMessageId) {
		this.replayMessageId = replayMessageId;
	}

	public String getSourceUrl() {
		return sourceUrl;
	}

	public void setSourceUrl(String sourceUrl) {
		this.sourceUrl = sourceUrl;
	}

	public String getThumbMediaId() {
		return thumbMediaId;
	}

	public void setThumbMediaId(String thumbMediaId) {
		this.thumbMediaId = thumbMediaId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getHqMusicUrl() {
		return hqMusicUrl;
	}

	public void setHqMusicUrl(String hqMusicUrl) {
		this.hqMusicUrl = hqMusicUrl;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}
}
