package com.rocoinfo.rocomall.entity.wx;

import java.util.ArrayList;
import java.util.List;

/***
 * 多图文消息，1个接收者
 */
public abstract class MultiMsgSingleReceiver implements WxMessage {

	private static final long serialVersionUID = 68831057064880301L;

	/***
	 * 获得消息接收者 如果消息的接收者可以是多个人，例如群发
	 * 
	 * @return
	 */
	public final List<MsgReceiverEntity> getMsgReceivers() {
		final List<MsgReceiverEntity> receiverList = new ArrayList<MsgReceiverEntity>(1);
		if (getMsgReceiver() != null) {
			receiverList.add(getMsgReceiver());
		}
		return receiverList;
	}

	public abstract MsgReceiverEntity getMsgReceiver();
}
