package com.rocoinfo.rocomall.enumconst;

/**
 * 微信接收消息类型/自动回复的消息类型
 */
public enum WXMsgType {

	/*
	 * ========= 接收普通消息类型 ===========
	 */

	/**
	 * 文本
	 */
	text("文本"),

	/***
	 * 图片消息
	 */
	image("图片"),

	/**
	 * 语音消息
	 */
	voice("语音"),

	/**
	 * 视频消息
	 */
	video("视频"),

	/**
	 * 地理位置
	 */
	location("地理位置"),

	/***
	 * 链接消息
	 */
	link("链接"),

	/*
	 * ========= 接收事件推送 类型 ===========
	 */

	/**
	 * 事件推送
	 */
	event("事件"),

	/**
	 * 图文消息
	 */
	news("图文"),

	/**
	 * 回复音乐消息
	 */
	music("音乐");

	WXMsgType(String msgTypeName) {
		this.msgTypeName = msgTypeName;
	}

	private String msgTypeName;

	public String getMsgTypeName() {
		return msgTypeName;
	}
}