package com.rocoinfo.rocomall.enumconst;

/**
 * 微信 事件
 */
public enum WxEvent {

	SUBSCRIBE("subscribe", "订阅"),

	UNSUBSCRIBE("unsubscribe", "取消订阅"),

	/**
	 * 上报地理位置事件
	 */
	LOCATION("LOCATION", "上报地理位置"),

	/**
	 * 自定义菜单点击事件
	 */
	CLICK("CLICK", "点击自定义菜单");

	WxEvent(String evtType, String evtName) {
		this.eventType = evtType;
		this.eventName = evtName;
	}

	/**
	 * 事件类型
	 */
	private String eventType;

	/**
	 * 事件名称
	 */
	private String eventName;

	public String getEventName() {
		return eventName;
	}

	public void setEventName(String eventName) {
		this.eventName = eventName;
	}

	public String getEventType() {
		return eventType;
	}

	public void setEventType(String eventType) {
		this.eventType = eventType;
	}

}
