package com.rocoinfo.rocomall.pay.kuaiqian;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.google.common.collect.Maps;

/**
 * 块钱支付
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-2 下午4:27:16</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@Component
public class KuaiQianPayHelper {

	private static Logger logger = LoggerFactory.getLogger(KuaiQianPayHelper.class);

	// public static final String URL =
	// "https://www.99bill.com/gateway/recvMerchantInfoAction.htm";
	public static final String URL = "https://sandbox.99bill.com/gateway/recvMerchantInfoAction.htm";// 测试地址
	public static String MERCHANTACCTID;// 接收款项的人民币账号
	public static String KEY;
	public static String KEY_NAME;
	public static String PRIVATE_RSA_PATH;// 私钥
	public static String PUBLIC_RSA_PATH;// 公钥

	public static Map<String, String> buildQueryParam(KuaiQianParm parm) {
		sign(parm);
		Map<String, String> params = Maps.newHashMap();
		params.put("inputCharset", parm.getInputCharset());
		// params.put("pageUrl", parm.getPageUrl());
		params.put("bgUrl", parm.getBgUrl());
		params.put("version", parm.getVersion());
		params.put("language", parm.getLanguage());
		params.put("signType", parm.getSignType());
		params.put("signMsg", parm.getSignMsg());
		params.put("merchantAcctId", MERCHANTACCTID);
		// params.put("payerName", parm.getPayerName());
		// params.put("payerContactType", parm.getPayerContactType());
		// params.put("payerContact", parm.getPayerContact());
		params.put("orderId", parm.getOrderId());
		params.put("orderAmount", parm.getOrderAmount());
		params.put("orderTime", parm.getOrderTime());
		// params.put("productName", parm.getProductName());
		// params.put("productNum", parm.getProductNum());
		// params.put("productId", parm.getProductId());
		// params.put("productDesc", parm.getProductDesc());
		// params.put("ext1", parm.getext1());
		// params.put("ext2", parm.getext2());
		params.put("payType", parm.getPayType());
		// params.put("bankId", parm.getBankId());
		// params.put("redoFlag", parm.getRedoFlag());
		// params.put("pid", parm.getPid());
		return params;
	}

	public static void sign(KuaiQianParm parm) {
		String signMsgVal = "";
		signMsgVal = appendParam(signMsgVal, "inputCharset", parm.getInputCharset());
		signMsgVal = appendParam(signMsgVal, "pageUrl", parm.getPageUrl());
		signMsgVal = appendParam(signMsgVal, "bgUrl", parm.getBgUrl());
		signMsgVal = appendParam(signMsgVal, "version", parm.getVersion());
		signMsgVal = appendParam(signMsgVal, "language", parm.getLanguage());
		signMsgVal = appendParam(signMsgVal, "signType", parm.getSignType());
		signMsgVal = appendParam(signMsgVal, "merchantAcctId", MERCHANTACCTID);
		// signMsgVal = appendParam(signMsgVal, "payerName", payerName);
		// signMsgVal = appendParam(signMsgVal, "payerContactType",
		// payerContactType);
		// signMsgVal = appendParam(signMsgVal, "payerContact", payerContact);
		signMsgVal = appendParam(signMsgVal, "orderId", parm.getOrderId());
		signMsgVal = appendParam(signMsgVal, "orderAmount", parm.getOrderAmount());
		signMsgVal = appendParam(signMsgVal, "orderTime", parm.getOrderTime());
		// signMsgVal = appendParam(signMsgVal, "productName", productName);
		// signMsgVal = appendParam(signMsgVal, "productNum", productNum);
		// signMsgVal = appendParam(signMsgVal, "productId", productId);
		// signMsgVal = appendParam(signMsgVal, "productDesc", productDesc);
		// signMsgVal = appendParam(signMsgVal, "ext1", ext1);
		// signMsgVal = appendParam(signMsgVal, "ext2", ext2);
		signMsgVal = appendParam(signMsgVal, "payType", parm.getPayType());
		// signMsgVal = appendParam(signMsgVal, "bankId", bankId);
		// signMsgVal = appendParam(signMsgVal, "redoFlag", redoFlag);
		// signMsgVal = appendParam(signMsgVal, "pid", pid);
		Pkipair pki = new Pkipair();
		logger.info("签名字符串:{}", signMsgVal);
		parm.setSignMsg(pki.signMsg(signMsgVal));
	}

	public static boolean validateData(HttpServletRequest request) {
		// 人民币网关账号，该账号为11位人民币网关商户编号+01,该值与提交时相同。
		String merchantAcctId = request.getParameter("merchantAcctId");
		// 网关版本，固定值：v2.0,该值与提交时相同。
		String version = request.getParameter("version");
		// 语言种类，1代表中文显示，2代表英文显示。默认为1,该值与提交时相同。
		String language = request.getParameter("language");
		// 签名类型,该值为4，代表PKI加密方式,该值与提交时相同。
		String signType = request.getParameter("signType");
		// 支付方式，一般为00，代表所有的支付方式。如果是银行直连商户，该值为10,该值与提交时相同。
		String payType = request.getParameter("payType");
		// 银行代码，如果payType为00，该值为空；如果payType为10,该值与提交时相同。
		String bankId = request.getParameter("bankId");
		// 商户订单号，该值与提交时相同。
		String orderId = request.getParameter("orderId");
		// 订单提交时间，格式：yyyyMMddHHmmss，如：20071117020101,该值与提交时相同。
		String orderTime = request.getParameter("orderTime");
		// 订单金额，金额以“分”为单位，商户测试以1分测试即可，切勿以大金额测试,该值与支付时相同。
		String orderAmount = request.getParameter("orderAmount");
		// 快钱交易号，商户每一笔交易都会在快钱生成一个交易号。
		String dealId = request.getParameter("dealId");
		// 银行交易号 ，快钱交易在银行支付时对应的交易号，如果不是通过银行卡支付，则为空
		String bankDealId = request.getParameter("bankDealId");
		// 快钱交易时间，快钱对交易进行处理的时间,格式：yyyyMMddHHmmss，如：20071117020101
		String dealTime = request.getParameter("dealTime");
		// 商户实际支付金额 以分为单位。比方10元，提交时金额应为1000。该金额代表商户快钱账户最终收到的金额。
		String payAmount = request.getParameter("payAmount");
		// 费用，快钱收取商户的手续费，单位为分。
		String fee = request.getParameter("fee");
		// 扩展字段1，该值与提交时相同。
		String ext1 = request.getParameter("ext1");
		// 扩展字段2，该值与提交时相同。
		String ext2 = request.getParameter("ext2");
		// 处理结果， 10支付成功，11 支付失败，00订单申请成功，01 订单申请失败
		String payResult = request.getParameter("payResult");
		// 错误代码 ，请参照《人民币网关接口文档》最后部分的详细解释。
		String errCode = request.getParameter("errCode");
		// 签名字符串
		String signMsg = request.getParameter("signMsg");
		String merchantSignMsgVal = "";
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "merchantAcctId", merchantAcctId);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "version", version);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "language", language);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "signType", signType);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "payType", payType);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "bankId", bankId);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "orderId", orderId);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "orderTime", orderTime);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "orderAmount", orderAmount);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "dealId", dealId);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "bankDealId", bankDealId);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "dealTime", dealTime);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "payAmount", payAmount);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "fee", fee);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "ext1", ext1);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "ext2", ext2);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "payResult", payResult);
		merchantSignMsgVal = appendParam(merchantSignMsgVal, "errCode", errCode);
		Pkipair pki = new Pkipair();
		return pki.enCodeByCer(merchantSignMsgVal, signMsg);
	}

	public static boolean isPaySuccess(HttpServletRequest request) {
		boolean isSignOk = validateData(request);
		logger.info("数据校验结果:{}", isSignOk);
		if (isSignOk) {
			String payResult = request.getParameter("payResult");
			// 处理结果， 10支付成功，11 支付失败，00订单申请成功，01 订单申请失败
			return StringUtils.equals(payResult, "10");
		}
		return false;
	}

	private static String appendParam(String returns, String paramId, String paramValue) {
		if (StringUtils.isNotBlank(returns)) {
			if (StringUtils.isNotBlank(paramValue) && !StringUtils.equals("null", paramValue)) {
				returns += "&" + paramId + "=" + paramValue;
			}
		} else {
			if (StringUtils.isNotBlank(paramValue) && !StringUtils.equals("null", paramValue)) {
				returns = paramId + "=" + paramValue;
			}
		}
		return returns;
	}
}
