package com.rocoinfo.rocomall.pay.wechat;

import java.net.InetAddress;
import java.util.UUID;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * 统一下单请求实体类
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-2 下午4:55:20</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@XmlType
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class UnifiedOrderParm {

	public UnifiedOrderParm(String body, String outTradeNo, int totalFee, String notifyUrl) {
		this();
		this.body = body;
		this.outTradeNo = outTradeNo;
		this.totalFee = totalFee;
		this.notifyUrl = notifyUrl;
	}

	public UnifiedOrderParm() {
		initDefaultVal();
	}

	private void initDefaultVal() {
		this.tradeType = "NATIVE";
		this.nonceStr = UUID.randomUUID().toString().replaceAll("-", "");
		try {
			this.spbillCreateIp = InetAddress.getLocalHost().getHostAddress();
		} catch (Exception e) {
			this.spbillCreateIp = "192.168.1.1";
			e.printStackTrace();
		}
	}

	@XmlElement(name = "appid", required = true)
	private String appId;

	@XmlElement(name = "mch_id", required = true)
	private String mchId;

	@XmlElement(name = "nonce_str", required = true)
	private String nonceStr;

	@XmlElement(name = "sign", required = true)
	private String sign;

	@XmlElement(name = "body", required = true)
	private String body;

	@XmlElement(name = "out_trade_no", required = true)
	private String outTradeNo;

	@XmlElement(name = "total_fee", required = true)
	private int totalFee; // 单位分

	@XmlElement(name = "spbill_create_ip", required = true)
	private String spbillCreateIp;

	@XmlElement(name = "notify_url", required = true)
	private String notifyUrl;

	@XmlElement(name = "trade_type", required = true)
	private String tradeType;

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public int getTotalFee() {
		return totalFee;
	}

	public void setTotalFee(int totalFee) {
		this.totalFee = totalFee;
	}

	public String getSpbillCreateIp() {
		return spbillCreateIp;
	}

	public void setSpbillCreateIp(String spbillCreateIp) {
		this.spbillCreateIp = spbillCreateIp;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}
}
