package com.rocoinfo.rocomall.repository.activity;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * 预售
 */
@MyBatisRepository
public interface ActivityDao extends CrudDao<Activity> {

	List<Activity> findListableTopActivitysGroupByType(Date now);

	List<Activity> search(Map<String, Object> params);

	List<Activity> findByIdIn(@Param("ids") List<Long> ids);

	/**
	 * @param now
	 *            系统当前时间：单位秒
	 */
	List<Activity> findListableActivity(long now);

	/**
	 * @param now
	 *            系统当前时间：单位秒
	 */
	List<Activity> findDelistableActivity(long now);

	void updateStatus(@Param("id") Long id, @Param("status") Activity.Status status);

	/**
	 * 更新下架时间, 可将下架时间设为null
	 * 
	 * @param id
	 *            活动ID
	 * @param delistTime
	 *            下架时间，可为null
	 */
	void updateDelistTime(@Param("id") Long id, @Param("delistTime") Date delistTime);

	List<Activity> findActivityByStatusAndType(@Param("status") Activity.Status status, @Param("type") Activity.Type type);

	List<Activity> findNeedCreateAuctionRefundRecodeActivity();

	Activity findByActivityName(@Param("name") String name, @Param("id") Long id);
}
