package com.rocoinfo.rocomall.repository.dict.express;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * 运费模板Dao
 * 
 * @author YUZHE 2015年11月25日 下午4:09:33
 */
@MyBatisRepository
public interface ExpressFeeTemplateDao extends CrudDao<ExpressFeeTemplate> {

	public ExpressFeeTemplate getByExpressId(Long expressId);

	public ExpressFeeTemplate getTemplateDetailById(Long id);

	/**
	 * 通过快递公司Id,统计该快递公司的模板数量
	 * 
	 * @param expressTemplate
	 */
	public long countTemplateByExpress(ExpressFeeTemplate expressTemplate);
}
