package com.rocoinfo.rocomall.repository.order;

import java.util.List;
import java.util.Map;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * <dl>
 * <dd>描述:入库单Dao</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/11/12 17:47</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
@MyBatisRepository
public interface InstoreOrderDao extends CrudDao<InstoreOrder> {

	/**
	 * 查询商品的入库记录
	 * 
	 * @param productId 产品Id
	 */
	public List<InstoreOrder> searchInstoreRecordsByProdId(Map<String, Object> params);

	public Long searchTotalInstoreRecordsByProdId(Map<String, Object> params);

}
