package com.rocoinfo.rocomall.service;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;

/**
 * <dl>
 * <dd>描述:管理员Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月3日 上午10:07:04</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public interface IAdminUserService extends IBaseService<AdminUser> {

	/**
	 * 更新管理员登录密码
	 */
	public void updateLoginPassword(final long adminId, final String newPlainPwd);

	/**
	 * 校验登录密码是否正确
	 * 
	 * @param username 用户名
	 * @param loginPassword 明文登录密码
	 */
	public boolean isLoginPasswordCorrect(final String username, final String loginPassword);

	/**
	 * 判断用户名是否已经被注册
	 * 
	 * @param username 登录用户名
	 */
	public boolean isUsernameRegisted(String username);

	/**
	 * 保存管理员，并保存相关的角色和能够管理员的供应商
	 * 
	 * @param admin 管理员 <br/>
	 *        throws ServiceException 如果admin用户名已存在，则抛出此异常
	 */
	public void saveAdminAndRole(final AdminUser admin) throws ServiceException;

	/**
	 * 更新管理员,并且更新角色和供应商
	 * 
	 * @param admin
	 */
	public void updateAdminAndRole(final AdminUser admin);

	/**
	 * 通过用户名获得管理员
	 * 
	 * @param username 用户名
	 */
	public AdminUser getAdminByUsername(final String username);

	/**
	 * 开通/关闭 管理员
	 * 
	 * @param adminId 用户名Id
	 * @param status 用户状态
	 */
	public void switchAdminStatus(final Long adminId, SwitchStatus status);

	/**
	 * 通过角色Id获取角色
	 * 
	 * @param roleId 角色Id
	 * @return 角色
	 */
	public Role getRoleById(final Long roleId);

	/**
	 * 查询构建角色拥有的权限
	 * 
	 * @param role 角色
	 */
	public void buildRolePermissionDetail(final Role role);

	/**
	 * 查询构建管理员拥有的权限信息（包括：角色、权限、能够管理的供应商）
	 * 
	 * @param admin
	 */
	public void buildAdminPermissionDetail(final AdminUser admin);

	/**
	 * 查找系统所有角色
	 */
	public List<Role> findAllRole();

	/**
	 * 保存角色，包括角色拥有的权限一起保存
	 * 
	 * @param role
	 */
	public void saveRoleAndPermissions(final Role role);

	/**
	 * 更新角色，角色拥有的权限一起更新
	 * 
	 * @param role
	 */
	public void updateRoleAndPermissions(final Role role);

	/**
	 * 删除角色，与此角色管理的权限数据关联删除
	 * 
	 * @param roleId 角色Id
	 */
	public void deleteRoleAndPermissionByRoleId(final Long roleId);

    public List<AdminUser> findAllWithStatus(SwitchStatus status);
}
