package com.rocoinfo.rocomall.service;

import java.util.List;
import java.util.Map;

import com.google.common.collect.ListMultimap;
import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.ProductSpecial;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/19 上午11:07</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IProductSpecialService extends IBaseService<ProductSpecial> {

	/**
	 * 根据type（skuId）查询
	 * 
	 * @param params
	 * @return
	 */
	public List<ProductSpecial> findProdSepecialByParams(Map<String, Object> params);

	/**
	 * @param catalogId 分类Id,如果不绑定到分类，则此参数传0
	 * @param typeCodeParams 设置的商品类型编号
	 */
	public ListMultimap<String, ProductSpecial> findSettingProductListMap(final long catalogId, ProductSpecialQueryParam... typeCodeParams);

	public void buildDetail(ProductSpecial productSpecial);

	public class ProductSpecialQueryParam {
		//分类code
		private String typeCode;
		//查询记录数
		private int limitNum;

		public ProductSpecialQueryParam(String typeCode, int limitNum) {
			this.typeCode = typeCode;
			this.limitNum = limitNum;
		}

		public String getTypeCode() {
			return typeCode;
		}

		public void setTypeCode(String typeCode) {
			this.typeCode = typeCode;
		}

		public int getLimitNum() {
			return limitNum;
		}

		public void setLimitNum(int limitNum) {
			this.limitNum = limitNum;
		}
	}

}
