package com.rocoinfo.rocomall.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.ActivityParticipationRecord;
import com.rocoinfo.rocomall.repository.ActivityParticipationRecordDao;
import com.rocoinfo.rocomall.service.IActivityParticipationRecordService;
import com.rocoinfo.rocomall.service.activity.IActivityService;

/**
 * <dl>
 * <dd>描述: </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/24 20:09</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
@Service
public class ActivityParticipationRecordService extends CrudService<ActivityParticipationRecordDao, ActivityParticipationRecord> implements IActivityParticipationRecordService {

    @Autowired
    private IActivityService activityService;

    @Override
    public List<ActivityParticipationRecord> queryActivityRecordsByUserId(Long userId) {
        List<ActivityParticipationRecord> list = this.entityDao.queryActivityRecordsByUserId(userId);
        for (ActivityParticipationRecord record : list) {
            this.activityService.buildActivityDetail(record.getActivity(), false);
        }
        return list;
    }
}
