package com.rocoinfo.rocomall.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.repository.SequenceDao;
import com.rocoinfo.rocomall.service.ISequenceService;

/**
 * @author zhangmin
 */
@Service
public class SequenceService implements ISequenceService {
	
	@Autowired
	private SequenceDao sequenceDao;
	
	public static enum SequenceTable{
		UPLOAD, DICT_PLAN(4),ADV_TYPE(4), CENT_RULE(4),INSTORE_CODE(6),COMPANY_CODE(6);
		
		SequenceTable(){
		}
		
		SequenceTable(int width){
			this.fixWidth = width;
		}
		
		//返回的code sequence,格式化成固定的宽度
		private int fixWidth;
		
		public int getFixWidth(){
			return this.fixWidth;
		}
	}
	

	/**
	 * 增加sequence的值,然后返回增加后sequence值
	 */
	public Integer getNextVal(SequenceTable seqTab){
		sequenceDao.next(seqTab);
		return sequenceDao.getCurVal(seqTab);
	}
}
