package com.rocoinfo.rocomall.service.impl;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.account.UserLevel;
import com.rocoinfo.rocomall.redis.CacheKeys;
import com.rocoinfo.rocomall.repository.account.UserLevelDao;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.IUserLevelService;

/**
 * <dl>
 * <dd>描述: 会员等级Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月4日 下午1:15:40</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Service
public class UserLevelService extends CrudService<UserLevelDao, UserLevel> implements IUserLevelService {

	@Autowired
	private IUploadService uploadService;

	@Override
	protected void evictCacheEntitysHook() {
		String allUserLevelKey = StringUtils.substringBetween(CacheKeys.USER_LEVEL_ALL_KEY, "'");
		cacheManager.getCache(CacheKeys.DEFAULT_NAME).evict(allUserLevelKey);
	}

	// 按积分值倒序排序
	@Override
	public List<UserLevel> findAll() {
		return super.findAll();
	}

	// 根据用户成长值获取用户等级
	public UserLevel getUserLevelByGrowth(Integer growth) {
		UserLevel userLevel = null;
		for (UserLevel level : findAll()) {
			if (growth >= level.getCent()) {
				userLevel = level;
				break;
			}
		}
		return userLevel;
	}

	/**
	 * 判断用户等级是否存在
	 * 
	 * @param userlevel
	 */
	public boolean isExistLevel(String level, Integer cent) {
		return this.entityDao.isExistLevel(level, cent) > 0;
	}

	@Override
	public void insert(UserLevel entity) {
		if (isExistLevel(entity.getLevel(), null)) {
			throw new ServiceException("用户等级已经存在!");
		}

		if (isExistLevel(null, entity.getCent())) {
			throw new ServiceException("积分已经存在!");
		}
		if (StringUtils.isNotBlank(entity.getImgUrl())) {
			entity.setImgUrl(uploadService.submitPath(entity.getImgUrl()));
		}
		super.insert(entity);
	}

	@Override
	public void update(UserLevel entity) {
		UserLevel dbLevel = this.getById(entity.getId());
		if (!StringUtils.equals(entity.getLevel(), dbLevel.getLevel())) {
			if (isExistLevel(entity.getLevel(), null)) {
				throw new ServiceException("用户等级已经存在!");
			}
		}
		if (entity.getCent() != dbLevel.getCent()) {
			if (isExistLevel(null, entity.getCent())) {
				throw new ServiceException("积分已经存在!");
			}
		}
		if (StringUtils.isNotBlank(entity.getImgUrl())) {
			entity.setImgUrl(uploadService.updateFile(entity.getImgUrl(), dbLevel.getImgUrl()));
		}
		super.update(entity);
	}

	public UserLevelService getProxy() {
		return (UserLevelService) AopContext.currentProxy();
	}
}