package com.rocoinfo.rocomall.service.impl.coupons;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.CouponsInfoDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.coupons.CouponsInfo;
import com.rocoinfo.rocomall.entity.coupons.CouponsProvideInfo;
import com.rocoinfo.rocomall.entity.coupons.CouponsProvideInfo.Status;
import com.rocoinfo.rocomall.repository.account.UserDao;
import com.rocoinfo.rocomall.repository.coupons.CouponsInfoDao;
import com.rocoinfo.rocomall.repository.coupons.CouponsProvideInfoDao;
import com.rocoinfo.rocomall.service.coupons.ICouponsInfoService;

@Service
public class CouponsInfoService extends CrudService<CouponsInfoDao, CouponsInfo> implements ICouponsInfoService {

	@Autowired
	private UserDao userDao;
	@Autowired
	private CouponsProvideInfoDao couponsProvideInfoDao;
	
	/**
	 * 根据code查询 code是否存在  
	 * @param code
	 * @return	true:存在，false：不存在
	 * 2015年12月11日 下午3:50:46
	 */
	@Override
	public boolean isHasCode(String code) {
		if(code == null){
			throw new ServiceException("优惠卷编号为空！");
		}
		Map<String,Object> params = new HashMap();
		params.put("code", code);
		return entityDao.searchTotal(params) > 0;
	}

	@Override
	public void updateStatus(Long id) {
		entityDao.updateStatus(id);
	}

	/**
	 * 批量导入 并 验证
	 */
	@Override
	public Object batchProvide(List<CouponsInfoDto> cardList) {
		if (CollectionUtils.isEmpty(cardList)) {
			return StatusDto.buildSuccessStatusDto("excel中没有数据,无需导入");
		}
		
		int lineNumber = 1;
		String temp = "第%s行%s列";
		Map<String, String> errorMsg = Maps.newLinkedHashMap();
		
		Set<String> codeSet = new HashSet<String>();
		Set<String> userNameSet = new HashSet<String>();
		
		for(CouponsInfoDto info : cardList){
			lineNumber++;
			if(info.getCode() == null){
				errorMsg.put(String.format(temp, lineNumber,1), "优惠卷编码为空！");
			}
			if(info.getUserName() == null){
				errorMsg.put(String.format(temp, lineNumber,2), "用户名为空！");
			}
			codeSet.add(info.getCode());
			userNameSet.add(info.getUserName());
		}
		
		if(errorMsg.size() != 0){
			return StatusDto.buildDataFailureStatusDto(printErrMsg(errorMsg));
		}
		
		List<String> codeList = new ArrayList();
		List<String> userNameList = new ArrayList();
		
		codeList.addAll(codeSet);
		userNameList.addAll(userNameSet);
		
		List<CouponsInfo> resultCodeList = entityDao.findCouponsByCode(codeList);
		List<User> resultUserNameList = userDao.findUserByUserNames(userNameList);
		
		Map<String,CouponsInfo> codeMap = new HashMap();
		Map<String,User> userMap = new HashMap();
		
		for(CouponsInfo info : resultCodeList){
			codeMap.put(info.getCode(), info);
		}
		for(User user : resultUserNameList){
			userMap.put(user.getUsername(), user);
		}
		
		
		if(resultCodeList.size() != codeList.size() || resultUserNameList.size() != userNameList.size()){
			lineNumber = 0;
			for(CouponsInfoDto info : cardList){
				lineNumber++;
				if(codeMap.get(info.getCode()) == null){
					errorMsg.put(String.format(temp, lineNumber,1), "不存在此优惠卷！");
				}
				if(userMap.get(info.getUserName()) == null){
					errorMsg.put(String.format(temp, lineNumber,2), "不存在此用户！");
				}
			}
			return StatusDto.buildDataFailureStatusDto(printErrMsg(errorMsg));
		}
		
		List<CouponsProvideInfo> infoList = new ArrayList();
		
		for(CouponsInfoDto info : cardList){
			CouponsProvideInfo cpi = new CouponsProvideInfo();
			CouponsInfo ci = new CouponsInfo();
			ci.setId(codeMap.get(info.getCode()).getId());
			cpi.setCoupons(ci);
			User user = new User();
			user.setId(userMap.get(info.getUserName()).getId());
			cpi.setUser(user);
			cpi.setCreateTime(new Date());
			cpi.setUsed(false);
			cpi.setStatus(Status.EFFECTIVE);
			infoList.add(cpi);
		}
		getProxy().batchInsert(infoList);
		return StatusDto.buildDataSuccessStatusDto("批量发放成功！");
	}
	
	
	
	private String printErrMsg(Map<String,String> errmsg){
		StringBuilder error = new StringBuilder(100);
		Iterator<String> iterator = errmsg.keySet().iterator();
		while (iterator.hasNext()) {
			String k = iterator.next();
			error.append(k).append(":").append(errmsg.get(k)).append(";");
		}
		return error.toString();
	}
	
	private CouponsInfoService getProxy(){
		return (CouponsInfoService) AopContext.currentProxy();
	}

	/**
	 * 批量插入
	 */
	@Override
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void batchInsert(List<CouponsProvideInfo> infoList) {
		if(infoList != null && infoList.size()>0){
			entityDao.batchInsert(infoList);
		}
	}

}
