package com.rocoinfo.rocomall.service.impl.dict;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.dict.DictCentAttribution;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.repository.dict.DictCentAttributionDao;
import com.rocoinfo.rocomall.service.dict.IDictCentAttributionService;

@Service
public class DictCentAttributionService extends CrudService<DictCentAttributionDao, DictCentAttribution> implements IDictCentAttributionService {

	public boolean isExistCode(final String code) {
		if (StringUtils.isBlank(code)) {
			return false;
		}
		for (DictCentAttribution cenc : findAll()) {
			if (cenc != null && cenc.getCode().equalsIgnoreCase(code)) {
				return true;
			}
		}
		return false;
	}

	public boolean isExistName(final String name) {
		if (StringUtils.isBlank(name)) {
			return false;
		}

		for (DictCentAttribution consumeOwner : findAll()) {
			if (consumeOwner.getName().equalsIgnoreCase(name)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public void insert(DictCentAttribution entity) {
		if (isExistCode(entity.getCode())) {
			throw new ServiceException("code已存在");
		}

		if (isExistName(entity.getName())) {
			throw new ServiceException("名称已存在");
		}
		entity.setStatus(Status.OPEN);
		super.insert(entity);
	}

	@Override
	public void update(DictCentAttribution centConsumeOwner) {
		DictCentAttribution oldConsumeType = getById(centConsumeOwner.getId());
		if (!oldConsumeType.getName().equalsIgnoreCase(centConsumeOwner.getName()) && isExistName(centConsumeOwner.getName())) {
			throw new ServiceException("名称已存在,请换个名称!");
		}
		super.update(centConsumeOwner);
	}
}