package com.rocoinfo.rocomall.service.impl.dict;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.DictPlatform;
import com.rocoinfo.rocomall.repository.dict.DictPlatformDao;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.dict.IDictPlatformService;

/**
 * @author zhangmin
 */
@Service
public class DictPlatformService extends CrudService<DictPlatformDao, DictPlatform> implements IDictPlatformService {

	@Autowired
	private IUploadService uploadService;

	public DictPlatform getPlatformByCode(final String code) {
		DictPlatform platform = null;
		if (StringUtils.isNotEmpty(code)) {
			for (DictPlatform pla : super.findAll()) {
				if (pla != null && pla.getCode().equals(code)) {
					platform = pla;
					break;
				}
			}
		}
		return platform;
	}

	public void insert(DictPlatform platform) {
		if (platform != null) {
			if (StringUtils.isNotBlank(platform.getIconPath())) {
				platform.setIconPath(uploadService.submitPath(platform.getIconPath()));
			}
			super.insert(platform);
		}
	}

	public void update(DictPlatform platform) {
		if (platform != null) {
			//删除旧图片文件，保存新图片文件
			if (platform.getIconPath() != null) {
				DictPlatform oldPlatform = super.getById(platform.getId());
				if (StringUtils.isNotBlank(oldPlatform.getIconPath()) && !oldPlatform.getIconPath().equals(platform.getIconPath())) {
					platform.setIconPath(uploadService.submitPath(platform.getIconPath()));
					uploadService.delete(oldPlatform.getIconPath());
				}
			}
			super.update(platform);
		}
	}

	public boolean isExistName(final String name) {
		if (StringUtils.isBlank(name)) {
			return false;
		}

		for (DictPlatform pla : super.findAll()) {
			if (pla != null && pla.getName().equalsIgnoreCase(name)) {
				return true;
			}
		}
		return false;
	}

	public boolean isExistCode(final String platformCode) {
		if (StringUtils.isBlank(platformCode)) {
			return false;
		}

		for (DictPlatform pla : super.findAll()) {
			if (pla != null && pla.getCode().equalsIgnoreCase(platformCode)) {
				return true;
			}
		}
		return false;
	}

	public List<DictPlatform> findByVisibility(Boolean visibility) {
		List<DictPlatform> all = findAll();
		if (visibility == null) {
			return all;
		}

		List<DictPlatform> filterDictPlats = new ArrayList<DictPlatform>();
		for (DictPlatform advType : all) {
			if (advType.getVisiable().equals(visibility)) {
				filterDictPlats.add(advType);
			}

		}
		return filterDictPlats;
	}

}
