package com.rocoinfo.rocomall.service.impl.product;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.ProductCatalog;
import com.rocoinfo.rocomall.repository.ProductCatalogDao;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.IProductCatalogService;

/**
 * 
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-3 下午3:11:54</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@Service
public class ProductCatalogService extends CrudService<ProductCatalogDao, ProductCatalog> implements IProductCatalogService {
	@Autowired
	private ICatalogService catalogService;

	public void insert(Long productId, Long catalogId) {
		super.insert(new ProductCatalog(productId, catalogId));
	}

	public void deleteByProductId(Long productId) {
		entityDao.deleteByProductId(productId);
	}

	public void deleteByProductIdAndCatalogId(Long productId, Long catalogId) {
		entityDao.deleteByProductIdAndCatalogId(new ProductCatalog(productId, catalogId));
	}

	public List<Long> findCatalogIdsByProductId(Long productId) {
		return entityDao.findCatalogIdsByProductId(productId);
	}

	public List<Catalog> findCatalogByProductId(Long productId) {
		List<Long> ids = findCatalogIdsByProductId(productId);
		List<Catalog> catalogs = new ArrayList<Catalog>(ids.size());
		for (Long id : ids) {
			Catalog catlog = catalogService.getById(id);
			if (null != catlog) {
				catalogs.add(catlog);
			}
		}
		return catalogs;
	}

}
