package com.rocoinfo.rocomall.service.impl.product;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springside.modules.utils.Collections3;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.ProductImage.ImageType;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.repository.ProductImageDao;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.product.IProductImageService;

/**
 * 商品图片DAO Created by robin on 14-6-12. author yangxc
 */
@Component
public class ProductImageService extends CrudService<ProductImageDao, ProductImage> implements IProductImageService {

	@Autowired
	private UploadService uploadService;

	public void insert(ProductImage productImage) {
		productImage.setPath(uploadService.submitPath(productImage.getPath()));
		super.insert(productImage);
	}

	/**
	 * 返回产品的所有图片，包括 主图 和 产品所有sku组合的图片
	 */
	public List<ProductImage> getByProductId(Long productId) {
		return entityDao.getByProductId(productId);
	}

	public List<ProductImage> findByProductIdIn(List<Long> productIdList) {
		return entityDao.findByProductIdIn(productIdList);
	}

	public List<ProductImage> getBySkuId(Long skuId) {
		return entityDao.getBySkuId(skuId);
	}

	/**
	 * 返回某个产品的所有主图
	 * 
	 * @param productId
	 *            产品Id
	 */
	public List<ProductImage> getProductPrimaryImages(Long productId) {
		return entityDao.getProductPrimaryImages(productId);
	}

	public void update(ProductImage productImage) {
		// 删除旧图片文件，保存新图片文件
		if (productImage.getPath() != null) {
			productImage.setPath(uploadService.submitPath(productImage.getPath()));

			ProductImage oldProductImage = super.getById(productImage.getId());
			if (oldProductImage != null && oldProductImage.getPath() != null && !oldProductImage.getPath().equals(productImage.getPath())) {
				uploadService.delete(oldProductImage.getPath());
			}
		}

		super.update(productImage);
	}

	public void batchUpdate(List<ProductImage> oldProductImages, List<ProductImage> newProductImages, Product product, Sku sku) {
		int displayOrder = 0;
		for (ProductImage productImage : newProductImages) {
			productImage.setProduct(product);
			productImage.setSku(sku);
			productImage.setDisplayOrder(displayOrder++);
			if (sku != null) {
				productImage.setImageType(ImageType.SKU);
			}
			if (productImage.getImageType() == null) {
				productImage.setImageType(ImageType.ATTACH);
			}
		}

		// 删除已不要的图片
		@SuppressWarnings("unchecked")
		List<Long> newProductImagesIds = Collections3.extractToList(newProductImages, IdEntity.ID_FIELD_NAME);
		for (ProductImage oldProductImage : oldProductImages) {
			if (!newProductImagesIds.contains(oldProductImage.getId())) {
				delete(oldProductImage);
			}
		}

		// 更新或新增新图片
		int i = 0;
		for (ProductImage image : newProductImages) {
			image.setDisplayOrder(i);
			i++;
			if (image.getId() == null) {
				insert(image);
			} else {
				update(image);
			}
		}
	}

	public void batchUpdate(List<ProductImage> oldProductImages, List<ProductImage> newProductImages, Product product) {
		batchUpdate(oldProductImages, newProductImages, product, null);
	}

	@Override
	public void deleteById(Long id) {
		delete(super.getById(id));
	}

	public void delete(ProductImage productImage) {
		Assert.notNull(productImage.getId());
		super.deleteById(productImage.getId());
		uploadService.delete(productImage.getPath());
	}
}
