package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.insurance.InsuranceInfo;
import com.rocoinfo.rocomall.entity.wx.InsuranceBuyRecord;
import com.rocoinfo.rocomall.pay.MD5;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.insurance.InsuranceInfoDao;
import com.rocoinfo.rocomall.repository.wx.InsuranceBuyRecordDao;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.wx.IHitGoldEggService;
import com.rocoinfo.rocomall.utils.JsonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

import java.util.*;

/**
 * <dl>
 * <dd>描述:砸金蛋service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-11 下午5:59:08</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@Service
public class HitGoldEggService extends CrudService<InsuranceBuyRecordDao, InsuranceBuyRecord> implements IHitGoldEggService {

    @Autowired
    private InsuranceInfoDao insuranceInfoDao;

    @Autowired
    private IAddressService addressService;

    @Autowired
    private JedisTemplate jedisTemplate;

    @Override
    public List<String> createPrizePool(int meta[][]) {
        List<String> pool = new ArrayList<String>();
        for (int[] arr : meta) {
            for (int i = 0; i < arr[1]; i++) {
                pool.add(String.valueOf(arr[0]));
            }
        }
        Random random = new Random();
        for (int i = 0; i < 2; i++) {
            for (int j = 0; j < pool.size(); j++) {
                int index1 = random.nextInt(pool.size() - 1);
                String temp = pool.get(index1);
                pool.set(index1, pool.get(j));
                pool.set(j, temp);
            }
        }

        String[] result = pool.toArray(new String[pool.size()]);
        jedisTemplate.lpush(Constants.HIT_GOLD_EGG_POOL, result);
        return pool;
    }

    @Override
    public void initPrizePool(int meta[][]) {
        if (meta == null) {
            return;
        }
        if (this.entityDao.getGuessRecordCount(null) < 1) {
            jedisTemplate.del(Constants.HIT_GOLD_EGG_POOL);
            jedisTemplate.del(Constants.HIT_GOLD_EGG_COUNT);
            createPrizePool(meta);
        }
    }

    @Override
    public String guessGoldEggResult() {
        return jedisTemplate.lpop(Constants.HIT_GOLD_EGG_POOL);
    }

    @Override
    @Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
    public StatusDto hitEgg(String openId) {
        List<InsuranceBuyRecord> records = this.entityDao.getHitChanceByOpenId(openId);
        if (CollectionUtils.isEmpty(records) || records.size() < 1) {
            return StatusDto.buildStatusDto("不能参与", "2");
        }
        if (!jedisTemplate.hasKey(Constants.HIT_GOLD_EGG_POOL)) {
            int recordCount = this.entityDao.getGuessRecordCount(openId);
            if (recordCount > 0) {
                return StatusDto.buildStatusDto("已经抽奖过一次", "3");
            }
            return StatusDto.buildStatusDto("没有奖品了", "5");
        }
        InsuranceBuyRecord record = Collections3.getFirst(records);
        Long index = jedisTemplate.incr(Constants.HIT_GOLD_EGG_COUNT);
        if (index % 3 != 0) {
            record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.NOHIT);
            this.entityDao.update(record);
            return StatusDto.buildStatusDto("没有中奖", "4");
        }
        String prizeId = guessGoldEggResult();
        if (StringUtils.isBlank(prizeId)) {
            record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.NOHIT);
            this.entityDao.update(record);
            return StatusDto.buildStatusDto("没有奖品了", "5");
        }
        record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.HIT);
        record.setPrizeId(prizeId);
        this.entityDao.update(record);
        StatusDto<Map> mapDto = StatusDto.buildDataSuccessStatusDto("1");
        mapDto.setData(new HashMap<String, Object>());
        mapDto.getData().put("prizeId", prizeId);
        mapDto.getData().put("recordId", record.getId());
        return mapDto;
    }

    @Override
    public List<InsuranceBuyRecord> getHitRecordByOpenId(String openId) {
        return this.entityDao.getHitRecordByOpenId(openId);
    }

    @Override
    @Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
    public void saveAddress(Address address, Long recordId) {
        addressService.insert(address);
        InsuranceBuyRecord record = new InsuranceBuyRecord();
        record.setId(recordId);
        record.setAddress(address);
        this.entityDao.update(record);
    }

    @Override
    public InsuranceBuyRecord getByThirdOrderId(String thirdOrderId) {
        return this.entityDao.getByThirdOrderId(thirdOrderId);
    }

    /**
     * 支付结果反馈
     *
     * @param record
     */
    @Override
    public void payNotice(InsuranceBuyRecord record) {
        InsuranceBuyRecord dbRecord = getByThirdOrderId(record.getThirdOrderId());
        if (dbRecord != null) {
            if (dbRecord.getPayStatus() == InsuranceBuyRecord.PayStatus.SUCCESS
                    && record.getPayStatus() == InsuranceBuyRecord.PayStatus.FAIL) {
                throw new ServiceException("已经支付成功,无法更新");
            }
            record.setId(dbRecord.getId());
            this.update(dbRecord);
            return;
        }

        record.setTime(new Date());
        record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.INIT);
        this.insert(record);
    }

    @Override
    public List<InsuranceInfo> getInsuranceInfo(String openId, String policyNumber) {
        return insuranceInfoDao.selectSearch(openId, policyNumber);
    }

    @Override
    public InsuranceInfo getInsuranceById(Long id) {
        return insuranceInfoDao.getById(id);
    }

    @Override
    @Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
    public void saveByInsuranceInfo(InsuranceInfo info) {
        if(!StringUtils.equals("1",info.getPayStatus())){
            //说明没有购买成功
            return ;
        }
        String jsonStr = JsonUtils.pojoToJson(info);
        String md5 = MD5.getMD5ofStr(jsonStr);
        if (Collections3.getFirst(insuranceInfoDao.selectSearch(null, md5)) != null) {
            //说明已经保存过
            return ;
        }
        info.setTime(new Date());
        info.setMd5(md5);
        if (insuranceInfoDao.selectCountByIdno(info.getIdno()) == 0) {
            //说明还没有人为改被保险人购买过保险,只有第一次购买的人才有机会抽奖
            InsuranceBuyRecord record = new InsuranceBuyRecord();
            record.setThirdOrderId(info.getPolicyNumber());
            record.setPayStatus(InsuranceBuyRecord.PayStatus.SUCCESS);
            record.setTime(new Date());
            record.setOpenId(String.valueOf(info.getUserid()));
            record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.INIT);
            this.entityDao.insert(record);
        }
        insuranceInfoDao.insert(info);
    }
}
