package com.rocoinfo.rocomall.service.impl.wx;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.VelocityVariableNames;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.wx.Menu;
import com.rocoinfo.rocomall.entity.wx.MsgEntity;
import com.rocoinfo.rocomall.entity.wx.WXItem;
import com.rocoinfo.rocomall.entity.wx.WXMsg;
import com.rocoinfo.rocomall.entity.wx.WXMusic;
import com.rocoinfo.rocomall.entity.wx.WXUser;
import com.rocoinfo.rocomall.entity.wx.WxMessage;
import com.rocoinfo.rocomall.enumconst.WXMsgType;
import com.rocoinfo.rocomall.enumconst.WxEvent;
import com.rocoinfo.rocomall.repository.wx.WxMsgDao;
import com.rocoinfo.rocomall.service.wx.IWxMsgService;
import com.rocoinfo.rocomall.utils.VelocityUtils;

@Service
public class WxMsgService extends CrudService<WxMsgDao, WXMsg> implements IWxMsgService {

	@Autowired
	private WxUserService wxUserService;

	@Autowired
	private WxApiService wxAipService;

	/**
	 * 获取事件消息的回复
	 * 
	 * @return
	 */
	public WXMsg searchEventMsgReply(final String appId, final String appSecret, final WXMsg inMsg) {
		WXMsg replyMsg = null;
		if (inMsg != null) {

			final String openId = inMsg.getFromUserName();
			Map<String, Object> velocityCtxDataMap = new HashMap<String, Object>();
			velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_OPEN_ID, openId);

			//关注
			if (inMsg.getEvent().equals(WxEvent.SUBSCRIBE.getEventType())) {
				WXUser user = wxUserService.getWXUserByOpenId(openId);
				if (user == null) {
					user = new WXUser();
					user.setOpenId(openId);
					pullWxUserInfo(appId, appSecret, user);
				} else {
					user.setUnsubscribeTime(null);
					//如果昵称为空，在说明还没有获取用户基本信息
					if (StringUtils.isEmpty(user.getNickName())) {
						pullWxUserInfo(appId, appSecret, user);;
					}
				}

				if (wxUserService.isWxUserBounded(openId)) {
					user.setBoundTime(new Date());
				}

				user.setSubscribeTime(new Date());

				if (user.getId() == null) {
					wxUserService.insert(user);
				} else {
					wxUserService.update(user);
				}

				WxMessage wxMsg = this.entityDao.searchEventMsg(inMsg.getEvent());
				if (wxMsg != null) {
					replyMsg = convertToWXMsg(inMsg, wxMsg.getMsgContents(), velocityCtxDataMap);
				}
			} else if (inMsg.getEvent().equals(WxEvent.UNSUBSCRIBE.getEventType())) {
				//取消关注
				WXUser user = wxUserService.getWXUserByOpenId(openId);
				if (user != null) {
					//FIXME 删除 绑定关系
					user.setSubscribeTime(null);
					user.setBoundTime(null);
					user.setUnsubscribeTime(new Date());
					wxUserService.update(user);
					WxMessage wxMsg = entityDao.searchEventMsg(inMsg.getEvent());
					if (wxMsg != null) {
						replyMsg = convertToWXMsg(inMsg, wxMsg.getMsgContents(), velocityCtxDataMap);
					}
				}
			} else if (inMsg.getEvent().equals(WxEvent.CLICK.getEventType())) {
				// 自定义菜单点击事件
				String key = inMsg.getEventKey(); //菜单key值

				//是否必须绑定后才能访问
				boolean boundAccess = Boolean.valueOf(StringUtils.substringAfter(key, Menu.MENU_ACT_SEPERATOR));

				//				if (boundAccess && !wxUserDao.isWxUserBounded(openId)) {
				//					replyMsg = convertToWXMsg(inMsg, wxMsgDao.getDefaultRespMsg(MsgEntity.BIND_MSG), velocityCtxDataMap);
				//				} else {
				//					final String menuIdentifier = StringUtils.substringBefore(key, Menu.MENU_ACT_SEPERATOR);
				//					if (Menu.ACT_ORDER_QUERY.equals(menuIdentifier)) {
				//						//订单查询,获取我的订单数据 并放在velocityCtxDataMap中
				//
				//						//最近的一张订单
				//						Order recentOrder = orderDao.getRecentOrderInfo(openId);
				//						if (recentOrder == null) {
				//							replyMsg = convertToWXMsg(inMsg, wxMsgDao.getDefaultRespMsg(MsgEntity.WITHOUT_ORDER_MSG), velocityCtxDataMap);
				//						} else {
				//							String orderDetailUrl = SystemGlobals.getSettings().getWebSiteRootUrl() + "orderDetail.do?orderNo=%s&openId=%s";
				//							orderDetailUrl = String.format(orderDetailUrl, recentOrder.getOrderNo(), openId);
				//							velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_ORDER_DETAIL_URL, orderDetailUrl);
				//							velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_ORDER, recentOrder);
				//						}
				//					} else if (Menu.ACT_PERSONAL_INFO.equals(menuIdentifier)) {
				//						//个人信息
				//						OrderDeliverInfo recentDeliverInfo = ServiceLocatorImpl.newInstance().getWxUserService().getRecentOrderDeliverInfo(openId);
				//						velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_ADDR_INFO, recentDeliverInfo);
				//					} else if (Menu.ACT_LOGISTICS_INQUIRY.equals(menuIdentifier)) {
				//						//最近的一张订单 的物流信息
				//						Order recentOrder = orderDao.getRecentOrderInfo(openId);
				//						if (recentOrder == null) {
				//							replyMsg = convertToWXMsg(inMsg, wxMsgDao.getDefaultRespMsg(MsgEntity.WITHOUT_ORDER_MSG), velocityCtxDataMap);
				//						} else if (!recentOrder.isPossibleHasLogistic()) {
				//							replyMsg = convertToWXMsg(inMsg, wxMsgDao.getDefaultRespMsg(MsgEntity.WITHOUT_LOGISTIC_MSG), velocityCtxDataMap);
				//						} else {
				//							//已发货|已收货 根据运单号 获取物流信息，如果有物流信，则相应物流信息，否则相应“处理中”  
				//							LogisticInfo logisInfo = ServiceLocatorImpl.newInstance().getOrderService().getOrderLogisticsInfo(recentOrder.getExpressCompany().getCode(), recentOrder.getTransportNo());
				//
				//							if (logisInfo == null) {
				//								replyMsg = convertToWXMsg(inMsg, wxMsgDao.getDefaultRespMsg(MsgEntity.PROCESSING_LOGISTIC_MSG), velocityCtxDataMap);
				//							} else {
				//
				//								velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_ORDER_NO, recentOrder.getOrderNo());
				//								velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_LOGISTIC_NO, recentOrder.getTransportNo());
				//								velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_LOGISTIC_COMPANY, recentOrder.getExpressCompany().getName());
				//
				//								String currentLogisc = StringUtils.EMPTY;
				//								if (logisInfo.getTrack() != null && logisInfo.getTrack().getTrackItems() != null && !logisInfo.getTrack().getTrackItems().isEmpty()) {
				//									currentLogisc = logisInfo.getTrack().getTrackItems().get(0).getLogisticDesc();
				//								}
				//
				//								velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_LOGISTIC_INFO, currentLogisc);
				//
				//								String orderDetailUrl = SystemGlobals.getSettings().getWebSiteRootUrl() + "orderDetail.do?orderNo=%s&openId=%s";
				//								orderDetailUrl = String.format(orderDetailUrl, recentOrder.getOrderNo(), openId);
				//								velocityCtxDataMap.put(VelocityVariableNames.VAVIABLE_ORDER_DETAIL_URL, orderDetailUrl);
				//							}
				//						}
				//					}
				//
				//					//response菜单绑定的消息
				//					if (replyMsg == null) {
				//						replyMsg = convertToWXMsg(inMsg, wxMsgDao.getMenuClickReplyMsg(menuIdentifier), velocityCtxDataMap);
				//					}
				//				}

				//FIXME OVER.....
			}
		}
		return replyMsg;
	}

	/**
	 * 获取文本消息的 回复
	 * 
	 * @param inMsg
	 * @return
	 */
	public WXMsg searchTextMsgReply(final String appId, final String appSecret, final WXMsg inMsg) {
		return null;
	}

	private void pullWxUserInfo(final String appId, final String appSecret, WXUser wxUser) {
		WXUser userInfo = wxAipService.getWxUserInfo(appId, appSecret, wxUser.getOpenId());
		if (userInfo != null) {
			wxUser.setNickName(userInfo.getNickName());
			wxUser.setSex(userInfo.getSex());
			wxUser.setCountry(userInfo.getCountry());
			wxUser.setProvince(userInfo.getProvince());
			wxUser.setCity(userInfo.getCity());
			wxUser.setHeadImgUrl(userInfo.getHeadImgUrl());
		}
	}

	/**
	 * 转换为微信消息体
	 * 
	 * @param autoReplyMsg 自动回复用户的消息,非多图文消息时autoReplyMsg.size ==1
	 * @param viewParam velocity变量值
	 * @return
	 */
	private WXMsg convertToWXMsg(WXMsg inMsg, List<MsgEntity> autoReplyMsg, Map<String, Object> viewParam) {
		if (autoReplyMsg == null || autoReplyMsg.isEmpty())
			return null;

		WXMsg wxMsg = new WXMsg();
		wxMsg.setToUserName(inMsg.getFromUserName());
		wxMsg.setFromUserName(inMsg.getToUserName());
		wxMsg.setCreateTime((int) (System.currentTimeMillis() / 1000));

		int index = 1;
		List<WXItem> articles = new ArrayList<WXItem>();

		//例如：http://192.153.1.1/oa/
		String siteBasePath = PropertyHolder.getBaseurl();

		for (MsgEntity msgEntity : autoReplyMsg) {

			//自动回复的消息类型
			WXMsgType msgTypeEnum = msgEntity.getMsgType();
			wxMsg.setMsgType(msgTypeEnum.toString());

			if (index == 1) {
				// 如果为文本
				if (WXMsgType.text.equals(msgTypeEnum)) {
					// 如果有参数使用模板
					String content = VelocityUtils.renderTemplateContent(msgEntity.getContent(), viewParam);
					wxMsg.setContent(content);
				} else if (msgTypeEnum.equals(WXMsgType.news)) {
					//FIXME TODO  如果为图文/多条图文
					WXItem item = new WXItem();
					item.setTitle(VelocityUtils.renderTemplateContent(msgEntity.getTitle(), viewParam));

					if (StringUtils.isNotBlank(msgEntity.getDescription())) {
						item.setDescription(VelocityUtils.renderTemplateContent(msgEntity.getDescription(), viewParam));
					} else {
						item.setDescription(VelocityUtils.renderTemplateContent(msgEntity.getContent(), viewParam));
					}

					if (StringUtils.isNotBlank(msgEntity.getPicUrl())) {
						if (msgEntity.getPicUrl().indexOf("http://") > -1) {
							item.setPicurl(msgEntity.getPicUrl());
						} else {
							item.setPicurl(siteBasePath + msgEntity.getPicUrl());
						}
					}

					item.setUrl(VelocityUtils.renderTemplateContent(msgEntity.getUrl(), viewParam));
					articles.add(item);
				} else if (msgTypeEnum.equals(WXMsgType.music)) {
					//如果为声音
					WXMusic music = new WXMusic();
					music.setTitle(msgEntity.getTitle());
					music.setDescription(msgEntity.getDescription());

					String musciUrl = StringUtils.EMPTY;
					if (StringUtils.isNotBlank(msgEntity.getMusicURL())) {
						if (msgEntity.getMusicURL().indexOf("http://") > -1) {
							musciUrl = msgEntity.getMusicURL();
						} else {
							musciUrl = siteBasePath + msgEntity.getMusicURL();
						}
					}

					music.setMusicUrl(musciUrl);
					music.sethQMusicUrl(musciUrl);
					wxMsg.setMusic(music);
				}
			} else {
				WXItem item = new WXItem();
				item.setTitle(VelocityUtils.renderTemplateContent(msgEntity.getTitle(), viewParam));
				item.setDescription(VelocityUtils.renderTemplateContent(msgEntity.getContent(), viewParam));

				if (StringUtils.isNotBlank(msgEntity.getPicUrl())) {
					if (msgEntity.getPicUrl().indexOf("http://") > -1) {
						item.setPicurl(msgEntity.getPicUrl());
					} else {
						item.setPicurl(siteBasePath + msgEntity.getPicUrl());
					}
				}

				item.setUrl(VelocityUtils.renderTemplateContent(msgEntity.getUrl(), viewParam));

				articles.add(item);
			}
			index++;
		}

		if (!articles.isEmpty()) {
			wxMsg.setArticles(articles);
			wxMsg.setArticleCount(articles.size());
		}
		return wxMsg;
	}

}
