package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.wx.WxRedPackRecord;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.wx.WxRedPackRecordDao;
import com.rocoinfo.rocomall.service.wx.IWxRedPackRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


@Service
public class WxRedPackRecordService extends CrudService<WxRedPackRecordDao, WxRedPackRecord> implements IWxRedPackRecordService {

	private Logger log = LoggerFactory.getLogger(WxRedPackRecordService.class);

	@Autowired
	private JedisTemplate jedisTemplate;

	@Override
	public WxRedPackRecord getByOpenId(String openId) {
		return this.entityDao.getByOpenId(openId);
	}

	public int getCount(WxRedPackRecord.Type type,WxRedPackRecord.Status status) {
		return this.entityDao.getCount(type,status);
	}

	@Override
	public void updateRecordById(Long id, WxRedPackRecord.Status status, String wxsendListid) {
		this.entityDao.updateRecordById(id,  status,  wxsendListid);
	}

	@Override
	public void initRedPackPool(int[][] meta) {

		if(getCount(WxRedPackRecord.Type.INSUR_CALCULATE,WxRedPackRecord.Status.SUCCESS) >0){
			log.info("红包池子不能重新生成!");
			return ;
		}
		List<String> pool = new ArrayList<String>();
		for(int [] arr:meta){
			for(int i =0;i<arr[1];i++){
				pool.add(String.valueOf(arr[0]));
			}
		}
		Random random = new Random();
		for(int i =0;i<2;i++){
			for(int j =0;j<pool.size();j++){
				int index1 = random.nextInt(pool.size()-1);
				String temp =pool.get(index1);
				pool.set(index1, pool.get(j));
				pool.set(j, temp);
			}
		}
		String [] result =   pool.toArray(new String[pool.size()]);
		jedisTemplate.lpush(Constants.RED_PACK_POOL,result);
	}

}
