package com.rocoinfo.rocomall.service.order;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.entity.order.OrderInsurance;

/**
 * <dl>
 * <dd>描述: 保险单管理service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2016年1月5日12:55:46</dd>
 * <dd>创建人： Johnny</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IOrderInsuranceService extends IBaseService<OrderInsurance> {

	/**
	 * 根据订单编号查询订单
	 * 
	 * @param orderNo
	 * @return
	 */
	public OrderInsurance getByOrderCode(final String orderCode);

	/**
	 * 根据投保人手机号，查询所有保单信息
	 * 
	 * @param mobile
	 */
	public List<OrderInsurance> getByMobile(final String mobile);

	/**
	 * 新增保险单的同时，增加保险人和被保险人。
	 */
	public void insertOrder(final OrderInsurance orderInsurance, final InsuredInfo loginUser);
}
