package com.rocoinfo.rocomall.service.order;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;

/**
 * <dl>
 * <dd>描述:出库单Service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月16日 上午10:41:44</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
public interface IOrderOutStoreService extends IBaseService<OrderOutStore> {

	/**
	 * @Title: getMergeOrderOutStore
	 * @Description: 根据仓库、快递公司、商品编码 查询合单数据
	 * @param 参数列表
	 * @return List<OrderOutStore>
	 * @throws
	 */
	public List<OrderOutStore> getMergeOrderOutStore(final long dictWarehouseId, final long dictExpressId, final String skuCode);

	/**
	 * 出库操作
	 * 
	 * @param outStoreOrder
	 */
	public void execOutStore(OrderOutStore outStoreOrder);
	

	/**
	 * 搜索商品的出库记录
	 * 
	 * @param productId 产品Id
	 */
	public Page<OrderOutStore> searchOutstoreRecordsByProdId(Long productId, Pageable pageable);
	
	
	/**
	 * 通过出库单id  修改子订单状态
	 * @return
	 * 2015年12月2日 下午2:13:26
	 */
	public void upDateOrderItemStatus(OrderItem.Status outStatus,OrderItem.AdmStatus inStatus,Long id);
}
