package com.rocoinfo.rocomall.service.order;

import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.order.Order;

/**
 * <dl>
 * <dd>描述: 总订单service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/7/30 下午1:36</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IOrderService extends IBaseService<Order> {

	/**
	 * 释放或占用订单的“占用库存”
	 * 
	 * @param operateFlag 操作标记 1：释放库存，2：占用库存
	 */
	public void releaseOrOccupyStockByOrderId(Long orderId, int operateFlag);

	/**
	 * 根据订单编号查询订单
	 * 
	 * @param orderNo
	 * @return
	 */
	public Order getByOrderNo(final String orderNo);

	/**
	 * 保存购物车订单
	 */
	void saveCartOrder(Order order, Long loggedUserId);

	Page<Order> searchOrder(Map<String, Object> parameters, PageRequest pageable);
}
